package com.bcxin.risk.dynamic.dto;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.dto.data.ActivityCooperDTO;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.order.OrderForm;
import com.bcxin.risk.order.Transaction;
import com.bcxin.risk.report.domain.Report;
import com.bcxin.risk.user.domain.User;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * @author hzp
 * 订单动态看板数据结构
 * 数据结构属性与对应的模板key相对应
 */
@Data
public class DynamicOrderPanel implements Serializable {

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 支付方式：线上、线下
     */
    private String paymentMethod;

    /**
     * 支付类型：现金、转账
     */
    private String paymentType;

    /**
     * 订单支付金额
     */
    private String paymentAmount;

    /**
     * 原始金额
     */
    private String sourceAmount;

    /**
     * 修改后金额
     */
    private String updateAfterAmount;

    /**
     * 评估报告提交人id/操作人id
     */
    private String operateId;

    /**
     * 评估报告提交人名称/操作人名称
     */
    private String operateName;

    private String userName;

    /**
     * 承办方id
     */
    private String contractId;

    /**
     * 承办方名称
     */
    private String contractName;

    /**
     * 报告是否加急
     */
    private String reportUrgentName;

    /**
     * 支付金额
     */
    private String transactionAmount;

    /**
     * 选择的机构列表
     */
    private String orgNameList;

    public DynamicOrderPanel(User operateUser, OrderForm orderForm, Transaction transaction,
                             Report report,List<ActivityCooperDTO> orgList){
        Activity activity=orderForm.getActivity();
        this.activityId=safeTransfer(activity.getOid());
        this.activityName=safeTransfer(activity.getName());
        this.contractId=safeTransfer(activity.getOrg().getOid());
        this.contractName=safeTransfer(activity.getOrg().getName());

        this.orderId=safeTransfer(orderForm.getOid());
        this.orderNo=safeTransfer(orderForm.getOrderNo());
        this.paymentAmount=safeTransfer(orderForm.getAmount());
        this.sourceAmount=safeTransfer(orderForm.getSourceAmount());
        this.updateAfterAmount=safeTransfer(orderForm.getAmount());

        if(transaction!=null){
            this.paymentMethod=safeTransfer(transaction.getPaymentMode());
            this.paymentType=safeTransfer(transaction.getPaymentType());
            if(Objects.equals("1",paymentMethod)){
                this.paymentMethod="线上支付";
            }else if(Objects.equals("2",paymentMethod)){
                this.paymentMethod="线下支付";
            }
            this.transactionAmount=safeTransfer(transaction.getAmount());
        }
        if(report!=null){
           String reportUrgent=safeTransfer(report.getReportUrgent());
            if(Objects.equals("0",reportUrgent)){
                this.reportUrgentName="不需要加急";
            }else if(Objects.equals("3",reportUrgent)){
                this.reportUrgentName="需要加急";
            }
        }
        if(operateUser!=null){
            this.operateId=safeTransfer(operateUser.getOid());
            this.userName=operateUser.getUserName();
            if(StringUtil.isEmpty(operateName)){
                this.operateName=safeTransfer(operateUser.getUserName());
            }
        }

        this.orgNameList=getOrgNameList(orgList);
    }

    /**
     * 获取承办方选择的评估机构
     * @param orgList
     * @return
     */
    private static String getOrgNameList(List<ActivityCooperDTO> orgList){
        if(orgList==null || orgList.size()==0){
            return "";
        }

        String orgNameList="";
        for(ActivityCooperDTO dto : orgList){
            orgNameList+=dto.getName()+"、";
        }
        if(StringUtil.isNotEmpty(orgNameList)){
            orgNameList=orgNameList.substring(0,orgNameList.length()-1);
        }
        return orgNameList;
    }

    private static String safeTransfer(Object obj){
        if(obj!=null){
            return obj.toString();
        }
        return "";
    }
}
