package com.bcxin.risk.dynamic.dto;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.dto.data.ActivityCooperDTO;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.order.OrderForm;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.report.domain.Report;
import com.bcxin.risk.user.domain.User;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * @author hzp
 * 风评动态看板数据结构
 * 数据结构属性与对应的模板key相对应
 */
@Data
public class DynamicFengPingPanel implements Serializable {

    private String reportId;

    /**
     * 报告url
     */
    private String reportUrl;

    private String reportVersion;

    /**
     * 操作人
     */
    private String operateName;
    private String operateId;
    private String userName;

    private String activityId;

    private String activityName;

    private String contractId;

    /**
     * 承办方
     */
    private String contractName;

    private String orgId;

    /**
     * 风评机构
     */
    private String orgName;

    /**
     * 报告版本
     */
    private String reportVer;

    private String reSubmit;

    public DynamicFengPingPanel(){}

    public DynamicFengPingPanel(User operateUser, Org org,Activity activity,String reportUrl){
        this.activityId=safeTransfer(activity.getOid());
        this.activityName=safeTransfer(activity.getName());
        if(operateUser!=null){
            this.operateId=safeTransfer(operateUser.getOid());
            this.userName=operateUser.getUserName();
            if(StringUtil.isEmpty(this.operateName)){
                this.operateName=safeTransfer(operateUser.getUserName());
            }
        }
        if(org!=null){
            this.orgId=org.getOid().toString();
            this.orgName=org.getName();
        }
        this.reportUrl=reportUrl;
    }

    public DynamicFengPingPanel(User operateUser, Org org,Activity activity,String reportUrl,String reportType){
        this.activityId=safeTransfer(activity.getOid());
        this.activityName=safeTransfer(activity.getName());
        if(operateUser!=null){
            this.operateId=safeTransfer(operateUser.getOid());
            this.userName=operateUser.getUserName();
            if(StringUtil.isEmpty(this.operateName)){
                this.operateName=safeTransfer(operateUser.getUserName());
            }
        }
        if(org!=null){
            this.orgId=org.getOid().toString();
            this.orgName=org.getName();
        }
        this.reportUrl=reportUrl;
        if(Objects.equals(reportType,"1")){
            this.reportVer="编写人员";
        }else if(Objects.equals(reportType,"2")){
            this.reportVer="审核人员";
        }else if(Objects.equals(reportType,"3")){
            this.reportVer="评估专家-报告撰写专家";
        }else if(Objects.equals(reportType,"4")){
            this.reportVer="终稿";
        }else{
            this.reportVer="本地上传";
        }
    }

    public DynamicFengPingPanel(User operateUser, OrderForm orderForm,
                                Report report, Org org){
        Activity activity=orderForm.getActivity();
        this.activityId=safeTransfer(activity.getOid());
        this.activityName=safeTransfer(activity.getName());
        this.contractId=safeTransfer(activity.getOrg().getOid());
        this.contractName=safeTransfer(activity.getOrg().getName());

        if(operateUser!=null){
            this.operateId=safeTransfer(operateUser.getOid());
            this.userName=operateUser.getUserName();
            if(StringUtil.isEmpty(this.operateName)){
                this.operateName=safeTransfer(operateUser.getUserName());
            }
        }

        if(report!=null){
            this.reportId=safeTransfer(report.getOid());
            this.reportUrl="";
            this.reportVersion="";
        }

        if(org!=null){
            this.orgId=safeTransfer(org.getOid());
            this.orgName=safeTransfer(org.getName());
        }
    }

    public Org getPingGuOrg(List<ActivityCooperDTO> orgList){
        Org org=new Org();
        if(orgList!=null){
            for(ActivityCooperDTO dto : orgList){
                if(Objects.equals(dto.getServiceOrgType(),"1")){
                    org.setOid(Long.parseLong(dto.getOid()));
                    org.setName(dto.getName());
                    return org;
                }
            }
        }
        return null;
    }

    private static String safeTransfer(Object obj){
        if(obj!=null){
            return obj.toString();
        }
        return "";
    }

}
