package com.bcxin.risk.compose.source;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 会展场馆
 * @author 070
 */
@Entity
@Table(name = "venue_Outdoor")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class VenueOutdoor extends VenueBase {

    /** 建立时间 */
    private String buildDate;

    /** 经营范围 */
    private String jingyingfanwei;

    /** 经度 */
    private String jingdu;

    /** 纬度 */
    private String weidu;

    /** 涉桥情况图片 */
    private String programtwo;

    /** 涉水情况图片 */
    private String sheshuiqingkuangtupian;

    /** 营业执照 */
    private String zhizhao;

    /** 组织机构代码证 */
    private String daimazheng;

    /** 税务登记证 */
    private String shuiwuzheng;

    /** 其他资质文件 */
    private String other;

    /** 总用地面积 */
    private String mianji;

    /** 有效活动面积 */
    private String jianzhu;

    /** 建筑面积 */
    private String jianzhuarea;

    /** 场地平面图 */
    private String photo;

    /** 出入口数量 */
    private String churukoushuliang;

    /** 可容纳人数 */
    private String people;

    /** 固定厕所数量 */
    private String gudingcesuoshuliang;

    /** 场地最大负荷 */
    private String changguanzuidafuhe;

    /** 电源分布 */
    private String dianyuan;

    /** 配电柜/配电箱数量 */
    private String peidianguishuliang;

    /** 消防配备情况 */
    private String xiaofang;

    /** 场地消防验收意见书 */
    private String yijianshu;

    /** 紧急疏散口数量 */
    private String jinjishusankoushuliang;

    /** 配套设施位置图 */
    private String weizhitu;

    /** 场地介绍 */
    private String introduction;

    /** 区域位置 */
    private String adress;

    /** 涉桥情况 */
    private String programone;

    /** 涉水情况 */
    private String sheshuiqingkuang;

    /** 出入口宽度 */
    private String churukoukuandu;

    /** 出入口方位 */
    private String churukoufangwei;

    /** 经营设施及分布情况 */
    private String shes;

    /** 应急供电设备 */
    private String yingjigongdianshebei;

    /** 其他消防配备情况 */
    private String qitaxiaofangpeibeiqingkuang;

    /** 紧急疏散口宽度 */
    private String jinjishusankoukuandu;

    /** 疏散通道 */
    private String shusan;

    /** 无障碍通道 */
    private String wuzhangai;

    /** 通讯信号器 */
    private String tongxunxinhaoqi;

    /** 监控系统可用状态 */
    private String jiankongxitongkeyongzhuangtai;

    /** 应急广播 */
    private String guangbo;

    /** 应急照明 */
    private String zhaoming;

    /** 排水沟 */
    private String sheshi;

    /** 加油站/危险品仓库 */
    private String jiayouzhan;

    /** 停车位 */
    private String tingchewei;

    /** 周边建筑及商业密度 */
    private String zhoub;

    /** 避难场所 */
    private String binanchangsuo;

    /** 地铁站 */
    private String ditie;

    /** 公交车站 */
    private String busStation;

    /** 出租车站 */
    private String taxi;

    /** 公共交通 */
    private String gonggongjiaotong;

    /** 拥堵地段 */
    private String yongdudiduan;

}