package com.bcxin.risk.compose.source;

import com.bcxin.risk.base.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 风险管理信息库
 */
@Entity
@Table(name = "RISK_ComposeRisk")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ComposeRisk extends BaseBean {

	private static final long serialVersionUID = 1L;

    /**
     * 风险类型
     */
    private String type;

    /**
     * 风险因子
     */
    private String factor;

    /**
     * 风险因素
     */
    private String element;

    /**
     * 类别（内容适用情况）
     */
    private String catalog;

    /**
     * 标签
     */
    private String tags;

    /**
     * 风险管控建议
     */
    private String suggest;

}
