package com.bcxin.risk.compose.draft;

import com.bcxin.risk.base.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 报告模板（模板类，不与业务数据有关联）
 */
@Entity
@Table(name = "RISK_ComposeFrame")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ComposeFrame extends BaseBean {

	private static final long serialVersionUID = -6403313540738849131L;

	/**
	 * 模版名称
	 */
	private String name;

	/**
	 * 模版类型
	 * 字典：活动类型
	 */
	private String type;

	/**
	 * 备注
	 */
	private String comment;

	/**
	 * 来源 （0代表贡献，1代表私有）
	 */
	private String nature;

	/**
	 * 模板文件
	 */
	private String fileUrl;

	/**
	 * 所属风评机构（如果为空，则代表默认模板）
	 */
	private Long org_id;

	/**
	 * 激活状态
	 */
	private String active;


}
