package com.bcxin.risk.mybatis.org;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * 服务机构
 * @author luopeng
 *
 */
@TableName("RISK_ServiceOrg")
@Data
public class ServiceOrgM extends Model<ServiceOrgM> {

	private static final long serialVersionUID = 1L;

	@TableId
	private Long oid;

	// 盖章图片
	private String stampedPicture;

	/**
	 * logo
	 */
	private String logo;

	/**
	 * 介绍
	 */
	private String introduce;

	/**
	 * 专家团队
	 */
	private String experts;

	/**
	 * 目前针对类型为 风险评估商 的服务机构
	 * 机构服务模式
	 * 1,自营；2,第三方
	 */
	private String serviceMode;

	/**
	 * 服务机构类型
	 */
	private String serviceOrgType;

	private String contactName;

    private String experience;

	private String contactPhone;

	private String contactAddress;

	/**
	 * 营业执照号码
	 */
	private String business_license_num;

	/**
	 * 营业执照副本照片
	 */
	private String business_license;

	/**
	 * 财务联系方式
	 */
	private String financePhone;

	/**
	 * 是否为分销商； 0为不是，1为是
	 */
	private String distributionOrg;

	/**
	 * 是否已同步分销商;  0为不是，1为是
	 */
	private String syncDistribution;

	/**
	 * 营业执照审核状态 1：待审核，2：审核通过
	 */
	private String approvalStatus;

	private String comment;

	/**
	 * 机构的商户号，联动优势
	 */
	private String umpayMerId;

	/**
	 * 机构的商户号,宝付，用于分账
	 */
	private String boofooMerId;

	/**
	 * 最低报价
	 */
	private String minQuote;

	/**
	 * 是否同步审批系统，默认设置为未同步
	 */
	private String syncSP = "0";

	@Override
	protected Serializable pkVal() {
		return this.getOid();
	}

}
