package com.bcxin.risk.user.domain;

import com.bcxin.risk.org.domain.ExpertOrg;
import com.bcxin.risk.org.domain.ServiceOrg;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 专家用户实体
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_ExpertUser")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ExpertUser extends User {

	private static final long serialVersionUID = 1L;

	/**
	 * 所属服务机构，以后需要删除
	 */
	@ManyToOne(targetEntity = ServiceOrg.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "serviceOrg_id")
	private ServiceOrg serviceOrg;

	/**
	 * 所属机构
	 */
	@ManyToOne(targetEntity = ExpertOrg.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "expertOrg_id")
	private ExpertOrg expertOrg;

	/**
	 * 年龄
	 */
	private String age;

	/**
	 * 性别 (字典)
	 */
	private String sex;

	/**
	 * 政治面貌 (字典)
	 */
	private String political;

	/**
	 * 最高学历 (字典)
	 */
	private String education;

	/**
	 * 最高职称 (字典)
	 */
	private String workTitle;

	/**
	 * 从事风险评估年限
	 */
	private String workYear;

	/**
	 * 资质证书（图片，可多张）
	 */
	private String aptitude_cert;

	/**
	 * 工作经历
	 */
	private String workExperience;

	/**
	 * 个人简历（文档）
	 */
	private String resume;

	/**
	 * 来源，工作单位
	 */
	private String source;


	/**
	 * 任务类型 勘查、撰写字典
	 */
	private String expertTaskType;

	/**
	 * 头衔
	 */
	private String expertCategory;

	private String level;

	/**
	 * 任务报价
	 */
	private String taskQuote;


	/**
	 * 行业领域 (字典)
	 */
	private String industryCategory;


	/**
	 * 专家简介
	 */
	private String expertProduce;

	/**
	 * 审核状态 0 待完善 1待审核 2 审核通过 3审核不通过
	 */
	private String checkStatus;

	/**
	 * 身份证号
	 */
	private String cardNo;

	/**
	 * 出生年月
	 */
	private String birthday;

	/**
	 * 民族
	 */
	private String nation;

	/**
	 * 婚姻状况
	 */
	private String marital;

	/**
	 * 学历证号
	 */
	private String educationNo;

	/**
	 * 籍贯信息
	 */
	private String nativeInfo;
	/**
	 * 籍贯code
	 */
	private String nativeInfoCode;

	/**
	 * 任职公司或部门
	 */
	private String companyOrDept;

	/**
	 * 职务
	 */
	private String position;

	/**
	 * 工作居住地
	 */
	private String jobLiveAddr;
	/**
	 * 工作居住地code
	 */
	private String jobLiveAddrCode;

	/**
	 * 擅长专业
	 */
	private String professional;

	/**
	 * 教育经历
	 */
	private String educationExperience;

	/**
	 * 学术团体任职经历
	 */
	private String learningExperience;

	/**
	 * 曾主持/参加的课题、项目
	 */
	private String projectExperience;

	/**
	 * 曾发表的学术文章
	 */
	private String learningPaper;

	/**
	 * 曾获得的成功
	 */
	private String successExperience;

	/**
	 * 个人业绩实例
	 */
	private String personAchievement;

	/**
	 * 专家来源
	 */
	private String expertSource;


}
