package com.bcxin.risk.surveytk.enums;

/**
 * @author hzp
 * 踏勘计划任务状态
 */
public enum PlanStatusEnum {

    NON("NON","未完成"),
    CONTINUE("CONTINUE","进行中"),
    COMPLETE("COMPLETE","已完成"),
    CLOSE("CLOSE","任务关闭");

    private String key;
    private String alias;

    PlanStatusEnum(String key, String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public String getName(){return this.alias;}

    public static String getAlias(String key){
        for(PlanStatusEnum e : PlanStatusEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}