package com.bcxin.risk.surveytk.domain.dto;

import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.surveytk.enums.AcceptStatusEnum;
import com.bcxin.risk.surveytk.enums.TaskStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @author hzp
 * 踏勘任务列表输出对象
 */
@Data
public class SurveyTaskDataDto implements Serializable {

    /**
     * 主键id
     */
    private String oid;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 创建时间
     */
    private String createOn;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动场地
     */
    private String activityVenue;

    /**
     * 是否加急
     */
    private String reportUrgent;

    /**
     * 订单状态
     */
    private String orderStatus;

    /**
     * 订单状态名称
     */
    private String orderStatusName;

    /**
     * 任务状态
     */
    private String taskStatus;

    /**
     * 任务状态名称
     */
    private String taskStatusName;

    /**
     * 接收状态
     */
    private String acceptStatus;

    private String acceptStatusName;

    /**
     * 任务接收时间
     */
    private String acceptDate;

    /**
     * 任务完成时间
     */
    private String finishDate;

    /**
     * 踏勘人员id
     */
    private String tkUserId;

    /**
     * 真实名称
     */
    private String realName;

    /**
     * 咨询专家名称
     */
    private String consultationName;

    /**
     * 踏勘人员名称
     */
    private String tkUserName;

    private Page page;

    private String tkConfig;

    private String zjConfig;

    /**
     * 当前用户类型
     */
    private String currUserType;

    public SurveyTaskDataDto(){

    }
    public SurveyTaskDataDto(Map<String,Object> map){
        this.activityId=safeTransfor(map.get("activityId"));
        this.oid = safeTransfor(map.get("oid"));
        this.tkConfig=safeTransfor(map.get("tkConfig"));
        this.zjConfig=safeTransfor(map.get("zjConfig"));
        this.createOn=safeTransfor(map.get("createOn"));
        this.activityName=safeTransfor(map.get("activityName"));
        this.activityVenue=safeTransfor(map.get("activityVenue"));
        this.taskStatus=safeTransfor(map.get("taskStatus"));
        this.acceptStatus=safeTransfor(map.get("acceptStatus"));
        this.acceptDate=safeTransfor(map.get("acceptDate"));
        this.finishDate=safeTransfor(map.get("finishDate"));
        this.tkUserId=safeTransfor(map.get("tkUserId"));
        this.tkUserName=safeTransfor(map.get("tkUserName"));
        this.orderStatus=safeTransfor(map.get("orderStatus"));
        this.acceptStatusName=AcceptStatusEnum.getAlias(safeTransfor(map.get("acceptStatus")));
        this.reportUrgent=safeTransfor(map.get("reportUrgent"));
        this.taskStatusName= TaskStatusEnum.getAlias(safeTransfor(map.get("taskStatus")));
        this.realName=safeTransfor(map.get("realName"));
        this.consultationName=safeTransfor(map.get("consultationName"));
    }

    private String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }

}
