package com.bcxin.risk.survey.domain;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

import com.fasterxml.jackson.annotation.JsonBackReference;


/**
 * 查勘现场具体问题及反馈详情
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Survey_Info")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
public class Survey_Info extends SurveyProject {
	 
	private static final long	serialVersionUID	= 1L;

	/** 关联所属活动场馆阶段问卷 */
	@ManyToOne(targetEntity = Survey_Questionnaire.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "questionnaireId")
	@JsonBackReference
	private Survey_Questionnaire questionnaire = new Survey_Questionnaire();
	
	/**勘查结果  */
	private String answer;
	
	/** 是否下次勘查 */
	private boolean nextSurvey = false;
		
	/** 勘查照片 */
	@OneToMany(targetEntity = Survey_Photo.class, cascade = CascadeType.REMOVE,mappedBy="surveyInfo")
    private List<Survey_Photo> photos = new ArrayList<Survey_Photo>();
    
    /** 关联上次勘查ID */
    private String lastSurveyInfoId;
    
	/**  整改意见*/
	@ManyToOne(targetEntity = SurveyReform.class, fetch = FetchType.LAZY,cascade=CascadeType.ALL )
	@JoinColumn(name = "reformId")
	private SurveyReform surveyReform = new SurveyReform();
	
    private boolean replied;//该问题是否已回答
    
    /**  是否已存在*/
    @Transient
    private boolean existence;

    /** 关联上次勘查 */
    @Transient
    private Survey_Info lastSurvey;
    

}
