
package com.bcxin.risk.survey.domain;
import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.activity.Venue;
import lombok.Data;

import com.bcxin.risk.report.enums.SurveyStep;
import com.bcxin.risk.report.enums.TaskStatus;
import com.fasterxml.jackson.annotation.JsonBackReference;

/**
 * 勘查计划
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_SurveyPlan")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
public class SurveyPlan extends BaseBean {

	 

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = SurveyTask.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "taskId")
	private SurveyTask surveyTask = new SurveyTask(); //对应勘察任务

	// 勘察员工号
	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "userId")
	private User user = new User();
	
	private int time;//勘查次数

	@Enumerated(EnumType.STRING)
	private SurveyStep surveyStep;//勘察阶段
	
	@ManyToOne(targetEntity = Survey_FeedBack.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "feedBackId")
	private Survey_FeedBack feedBack = new Survey_FeedBack(); //对应勘查阶段

	@ManyToOne(targetEntity = Survey_Questionnaire.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "questionnaireId")
	@JsonBackReference
	private Survey_Questionnaire questionnaire;	//对应勘查场地问题
	
	@ManyToOne(targetEntity = Venue.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "venueId")
    private Venue venue = new Venue();
	
	@Enumerated(EnumType.STRING)
	private TaskStatus taskStatus; // 状态
	
	private Date beginTime;//查勘开始时间
	
	private Date endTime;//查勘结束时间

	private boolean allDay;
	
	private String remark;//备注

    private String signImgPath;//客户经理签名
    
    private String purveyorSignPath;//承办方负责人签名

    @Transient
    private boolean sign=false;
    

}
