package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;
/**
 * 
* @ClassName: UserRole  
* @Description: 角色枚举类
* @author 
* @date 2016年7月10日 下午2:36:59  
*
 */
public enum UserRole {

	CUSTOMER {public String getValue(){return "1";} public String getEname(){return "CUSTOMER";} public String getName(){return "客户";}}, 
	//材料审核专员
	ASSESSOR {public String getValue(){return "2";} public String getEname(){return "ASSESSOR";} public String getName(){return "审核专员";}}, 
	
	EDITER {public String getValue(){return "3";} public String getEname(){return "EDITER";} public String getName(){return "撰写专员";} },
	//勘查专家
	EXPERT {public String getValue(){return "4";} public String getEname(){return "EXPERT";} public String getName(){return "勘查专家";} },
	//一审人员
	FIRSTAUDIT {public String getValue(){return "5";} public String getEname(){return "FIRSTAUDIT";} public String getName(){return "一审人员";}}, 
	//二审专家
	ADVISER {public String getValue(){return "6";} public String getEname(){return "ADVISER";} public String getName(){return "二审人员";} },
	//行政人员（小霞说滴）
	MANAGER {public String getValue(){return "7";} public String getEname(){return "MANAGER";} public String getName(){return "行政人员";}}, 
	
	SERVICES {public String getValue(){return "8";} public String getEname(){return "SERVICES";} public String getName(){return "资讯维护";}},

	FINANCE {public String getValue(){return "9";} public String getEname(){return "FINANCE";} public String getName(){return "财务确认专员";}},
	//审核账号角色
	//市场部审核员
	MARKETING{public String getValue(){return "27";} public String getEname(){return "MARKETING";} public String getName(){return "市场部审核员";}},
	//运营部审核员
	OPERATIONS{public String getValue(){return "28";} public String getEname(){return "OPERATIONS";} public String getName(){return "运营部审核员";}},

	PM {public String getValue(){return "10";}public String getEname(){return "PM";}  public String getName(){return "项目经理";}},
	
	POLICE {public String getValue(){return "11";} public String getEname(){return "POLICE";} public String getName(){return "警方审核";}},
	
	CM {public String getValue(){return "12";} public String getEname(){return "CM";} public String getName(){return "客户经理";}},
	
	ADMIN {public String getValue(){return "20";} public String getEname(){return "ADMIN";} public String getName(){return "管理员";}},
	
	PRICEUPDATE {public String getValue(){return "13";} public String getEname(){return "PRICEUPDATE";} public String getName(){return "价格编辑人员";}},

	PRICECONFIRM {public String getValue(){return "14";} public String getEname(){return "PRICECONFIRM";} public String getName(){return "价格系数审核人员";}},
	//#202
	MATERIALINPUT {public String getValue(){return "15";} public String getEname(){return "MATERIALINPUT";} public String getName(){return "材料录入人员";}},

	REVIEW {public String getValue(){return "16";} public String getEname(){return "REVIEW";} public String getName(){return "复核人员";}},
	
	/**
	 * 风险评估商
	 */
	ASSESSMENT {public String getValue(){return "17";} public String getEname(){return "ASSESSMENT";} public String getName(){return "风险评估公司";}},

	SITE {public String getValue(){return "18";} public String getEname(){return "SITE";} public String getName(){return "场地提供方";}},

	SECURITY{public String getValue(){return "19";} public String getEname(){return "SECURITY";} public String getName(){return "安保公司";}},

	TICKET {public String getValue(){return "20";} public String getEname(){return "TICKET";} public String getName(){return "票务公司";}},

	SUPERVISOR {public String getValue(){return "21";} public String getEname(){return "SUPERVISOR";} public String getName(){return "监理公司";}},

	SAFETYCHECK {public String getValue(){return "22";} public String getEname(){return "SAFETYCHECK";} public String getName(){return "安检门供应商";}},
	
	STAGE {public String getValue(){return "23";} public String getEname(){return "STAGE";} public String getName(){return "临建公司";}},
	/**
	 * 添加公安角色   add  by  刘金炬
	 */
	BUREAUSEC {public String getValue(){return "24";} public String getEname(){return "BUREAUSEC";} public String getName(){return "公安";}},
	
	CATERING {public String getValue(){return "25";} public String getEname(){return "CATERING";} public String getName(){return "餐饮";}},
	
	EXPLODE {public String getValue(){return "26";} public String getEname(){return "EXPLODE";} public String getName(){return "防爆";}},
	
	SUPERADMIN {public String getValue(){return "99";} public String getEname(){return "SUPERADMIN";} public String getName(){return "超级管理员";}};

    public abstract String getValue();
    
    public abstract String getName();
    
    public abstract String getEname();
    
    public static List<UserRole> list(){
    	List<UserRole> list = new ArrayList<UserRole>();
    	list.add(CUSTOMER);
    	list.add(ASSESSOR);
    	list.add(EDITER);
    	list.add(EXPERT);
    	list.add(REVIEW);
    	list.add(FIRSTAUDIT);
    	list.add(ADVISER);
    	list.add(MANAGER);
    	//list.add(SERVICES);
    	list.add(FINANCE);
    	list.add(PM);
    	list.add(POLICE);
    	list.add(CM);
    	list.add(ADMIN);
    	list.add(PRICEUPDATE);
    	list.add(PRICECONFIRM);
    	list.add(MATERIALINPUT);
    	list.add(MARKETING);
		list.add(OPERATIONS);
    	return list;
    }
    /**
     * 
    * @Title: backlist  
    * @Description: 后台获取可设置角色
    * @param @return    设定文件  
    * @return List<UserRole>    返回类型  
    * @throws
     */
    public static List<UserRole> backlist(){
    	List<UserRole> list = new ArrayList<UserRole>();
    	list.add(ASSESSOR);
    	list.add(EDITER);
    	list.add(EXPERT);
    	list.add(REVIEW);
    	list.add(FIRSTAUDIT);
    	list.add(ADVISER);
    	list.add(MANAGER);
    	list.add(SERVICES);
    	list.add(FINANCE);
    	list.add(PM);
    	list.add(POLICE);
    	list.add(CM);
    	list.add(ADMIN);
    	list.add(PRICEUPDATE);
    	list.add(PRICECONFIRM);
    	list.add(MATERIALINPUT);
    	list.add(BUREAUSEC);
		list.add(MARKETING);
		list.add(OPERATIONS);
    	return list;
    }
    
    /**
     * 前台用户 列表
     * @return
     */
    public static List<UserRole> frontlist(){
    	List<UserRole> list = new ArrayList<UserRole>();
    	list.add(ASSESSMENT);
    	list.add(SITE);
    	list.add(SECURITY);
    	list.add(TICKET);
      	list.add(SUPERVISOR);
    	list.add(SAFETYCHECK);
    	list.add(STAGE);
    	list.add(BUREAUSEC);
    	list.add(EXPLODE);
    	list.add(CATERING);
    	return list;
    }
    /**
     * 前台+后台用户 列表
     * @return
     */
    
    public static List<UserRole>  frontAndbacklist(){
    	List<UserRole> list = new ArrayList<UserRole>();
    	list.add(ASSESSOR);
    	list.add(EDITER);
    	list.add(EXPERT);
    	list.add(REVIEW);
    	list.add(FIRSTAUDIT);
    	list.add(ADVISER);
    	list.add(MANAGER);
    	list.add(SERVICES);
    	list.add(FINANCE);
    	list.add(PM);
    	list.add(POLICE);
    	list.add(CM);
    	list.add(ADMIN);
    	list.add(PRICEUPDATE);
    	list.add(PRICECONFIRM);
    	list.add(MATERIALINPUT);
    	list.add(BUREAUSEC);
    	list.add(ASSESSMENT);
    	list.add(SITE);
    	list.add(SECURITY);
    	list.add(TICKET);
      	list.add(SUPERVISOR);
    	list.add(SAFETYCHECK);
    	list.add(STAGE);
    	list.add(BUREAUSEC);
    	list.add(EXPLODE);
    	list.add(CATERING);
		list.add(MARKETING);
		list.add(OPERATIONS);
    	return list;
    }
    
    
    public static UserRole convert_name(String name){
    	if("CUSTOMER".equals(name)){
    		return CUSTOMER;
    	} else if("ASSESSOR".equals(name)){
    		return ASSESSOR;
    	} else if("EDITER".equals(name)){
    		return EDITER;
    	} else if("EXPERT".equals(name)){
    		return EXPERT;
    	} else if("REVIEW".equals(name)){
    		return REVIEW;
    	} else if("FIRSTAUDIT".equals(name)){
    		return FIRSTAUDIT;
    	} else if("ADVISER".equals(name)){
    		return ADVISER;
    	} else if("MANAGER".equals(name)){
    		return MANAGER;
    	} else if("SERVICES".equals(name)){
    		return SERVICES;
    	} else if("FINANCE".equals(name)){
    		return FINANCE;
    	} else if("PM".equals(name)){
    		return PM;
    	} else if("POLICE".equals(name)){
    		return POLICE;
    	} else if("CM".equals(name)){
    		return CM;
    	} else if("ADMIN".equals(name)){
    		return ADMIN;
    	} else if("PRICEUPDATE".equals(name)){
    		return PRICEUPDATE;
    	} else if("PRICECONFIRM".equals(name)){
    		return PRICECONFIRM;
    	} else if("MATERIALINPUT".equals(name)){
    		return MATERIALINPUT;
    	} else if("ASSESSMENT".equals(name)){
    		return ASSESSMENT;
    	} else if("SITE".equals(name)){
    		return SITE;
    	} else if("SECURITY".equals(name)){
    		return SECURITY;
    	} else if("TICKET".equals(name)){
    		return TICKET;
    	} else if("SUPERVISOR".equals(name)){
    		return SUPERVISOR;
    	} else if("SAFETYCHECK".equals(name)){
    		return SAFETYCHECK;
    	} else if("STAGE".equals(name)){
    		return STAGE;
    	} else if("BUREAUSEC".equals(name)){
    		return BUREAUSEC;
    	} else if("SUPERADMIN".equals(name)){
    		return SUPERADMIN;
    	} else if("EXPLODE".equals(name)){
    		return EXPLODE;
    	} else if("CATERING".equals(name)){
    		return CATERING;
    	} else if("MARKETING".equals(name)){
			return MARKETING;
		} else  if("OPERATIONS".equals(name)){
			return OPERATIONS;
		} else{
    		return null;
    	}
    }
    
    public static UserRole convert_value(String value){
    	if("1".equals(value)){
    		return CUSTOMER;
    	} else if("2".equals(value)){
    		return ASSESSOR;
    	} else if("3".equals(value)){
    		return EDITER;
    	} else if("4".equals(value)){
    		return EXPERT;
    	} else if("5".equals(value)){
    		return FIRSTAUDIT;
    	} else if("6".equals(value)){
    		return ADVISER;
    	} else if("7".equals(value)){
    		return MANAGER;
    	} else if("8".equals(value)){
    		return SERVICES;
    	} else if("9".equals(value)){
    		return FINANCE;
    	} else if("10".equals(value)){
    		return PM;
    	} else if("11".equals(value)){
    		return POLICE;
    	} else if("12".equals(value)){
    		return CM;
    	} else if("20".equals(value)){
    		return ADMIN;
    	} else if("13".equals(value)){
    		return PRICEUPDATE;
    	} else if("14".equals(value)){
    		return PRICECONFIRM;
    	} else if("15".equals(value)){
    		return MATERIALINPUT;
    	} else if("16".equals(value)){
    		return REVIEW;
    	} else if("27".equals(value)){
			return MARKETING;
		} else if("28".equals(value)){
			return OPERATIONS;
		} else{
    		return null;
    	}
    }
    
    public static boolean isBackRole(List<UserRole> roles){
    	List<UserRole> maRoleList = new ArrayList<UserRole>();
    	maRoleList.add(ADMIN);
    	maRoleList.add(PM);
		maRoleList.add(SERVICES);
		maRoleList.add(MARKETING);
		maRoleList.add(OPERATIONS);
    	for ( UserRole role : maRoleList ) {
    		if ( roles.contains(role) ) {
    			return true;
    		}
    	}
    	return false;
    }
}
