package com.bcxin.risk.report.enums;

/**
 * 审核状态
 * @author luopeng
 *
 */
public enum ApprovalStatus {
	
	NON {public String getValue(){return "1";} public String getName(){return "未审批";}}, 
	
	PASS{public String getValue(){return "2";} public String getName(){return "审核通过";}},
	
	REJECT {public String getValue(){return "3";} public String getName(){return "审核不通过";}};

    public abstract String getValue();
    
    public abstract String getName();
    
    public static ApprovalStatus convert(String value){
    	if ( "NON".equals(value) ) {
    		return ApprovalStatus.NON;
    	} else if ("PASS".equals(value)) {
    		return ApprovalStatus.PASS;
    	}else if ("REJECT".equals(value)) {
    		return ApprovalStatus.REJECT;
    	}
    	return null;
    }
 
}
