package com.bcxin.risk.policy.enums;

import java.util.HashMap;
import java.util.Map;


public enum Policy_ActivityQuota {

	
	CPIC_LEVEL_ONE {public String getValue(){return "1";} public String getName(){return "人民币400万≤累计赔偿限额＜人民币600万";}}, 
	
	CPIC_LEVEL_TWO {public String getValue(){return "2";} public String getName(){return "人民币600万≤累计赔偿限额＜人民币800万";} }, 
	
	CPIC_LEVEL_THREE {public String getValue(){return "3";} public String getName(){return "人民币800万≤累计赔偿限额＜人民币1000万";} }, 
	
	CPIC_LEVEL_FOUR {public String getValue(){return "4";} public String getName(){return "人民币1000万≤累计赔偿限额＜人民币1500万";} }, 
	
	CPIC_LEVEL_FIVE {public String getValue(){return "5";} public String getName(){return "人民币1500万≤累计赔偿限额＜人民币2000万";} }, 
	
	CPIC_LEVEL_SIX {public String getValue(){return "6";} public String getName(){return "累计赔偿限额≥人民币2000万";} },
	
	
	HT_LEVEL_ONE {public String getValue(){return "11";} public String getName(){return "人民币500万≤累计赔偿限额＜人民币3500万";}}, 
	
	HT_LEVEL_TWO {public String getValue(){return "12";} public String getName(){return "人民币1000万≤累计赔偿限额＜人民币3500万";} }, 
	
	HT_LEVEL_THREE {public String getValue(){return "13";} public String getName(){return "人民币1500万≤累计赔偿限额＜人民币3500万";} }, 
	
	HT_LEVEL_FOUR {public String getValue(){return "14";} public String getName(){return "人民币2000万<人民币3500万";} }; 
	
	
    public abstract String getValue();
    
    public abstract String getName();
    
    public static Policy_ActivityQuota calc(String number,String days,InsuranceCompany company){
    	int num = Integer.parseInt(number);
    	int day = Integer.parseInt(days);
    	if ( InsuranceCompany.CPIC_PROPERTY.equals(company) ) {
    		if ( 10000 <= num && day <= 3 ) {
        		return CPIC_LEVEL_ONE;
        	} else if ( 10000 < num && num <= 50000 && day <= 3 ) {
        		return CPIC_LEVEL_TWO;
        	} else if( 50000 < num && day <= 3 ) {
        		return CPIC_LEVEL_THREE;
        	} else if( 10000 <= num && day > 3 ) {
        		return CPIC_LEVEL_FOUR;
        	} else if( 10000 < num && num <= 50000 && day > 3 ) {
        		return CPIC_LEVEL_FIVE;
        	} else if( 50000 < num && day > 3 ) {
        		return CPIC_LEVEL_SIX;
        	}
    	}
    	if ( InsuranceCompany.HT.equals(company) ) {
    		if (num<=  5000  ) {
        		return HT_LEVEL_ONE;
        	} else if ( 5000 < num && num <= 10000 ) {
        		return HT_LEVEL_TWO;
        	} else if( 10000 < num && num <= 50000 ) {
        		return HT_LEVEL_THREE;
        	} else if( 50000 < num ) {
        		return HT_LEVEL_FOUR;
        	}
    	}
    	return null;
    }
    
    
    public  static  Policy_ActivityQuota     getLevel(String number){
    	int num = Integer.parseInt(number);
    	if (num<  1000  ) {
    		return HT_LEVEL_ONE;
    	} else if ( num < 1500 ) {
    		return HT_LEVEL_TWO;
    	} else if( num < 2000 ) {
    		return HT_LEVEL_THREE;
    	} else if( num<= 3500 ) {
    		return HT_LEVEL_FOUR;
    	}
    	return HT_LEVEL_ONE;
    }
    
    public static Map<String,String> calcLimit(Policy_ActivityQuota quota){
    	Map<String,String> map = new HashMap<String,String>();
    	if ( CPIC_LEVEL_ONE.equals(quota) ) {
    		map.put("minLimit", "400");
    		map.put("maxLimit", "600");
    	} else if ( CPIC_LEVEL_TWO.equals(quota) ) {
    		map.put("minLimit", "600");
    		map.put("maxLimit", "800");
    	} else if ( CPIC_LEVEL_THREE.equals(quota) ) {
    		map.put("minLimit", "800");
    		map.put("maxLimit", "1000");
    	} else if ( CPIC_LEVEL_FOUR.equals(quota) ) {
    		map.put("minLimit", "1000");
    		map.put("maxLimit", "1500");
    	} else if ( CPIC_LEVEL_FIVE.equals(quota) ) {
    		map.put("minLimit", "1500");
    		map.put("maxLimit", "2000");
    	} else if ( CPIC_LEVEL_SIX.equals(quota) ) {
    		map.put("minLimit", "2000");
    		map.put("maxLimit", "10000");
    	} else if ( HT_LEVEL_ONE.equals(quota) ) {
    		map.put("minLimit", "500");
    		map.put("maxLimit", "3500");
    	} else if ( HT_LEVEL_TWO.equals(quota) ) {
    		map.put("minLimit", "1000");
    		map.put("maxLimit", "3500");
    	} else if ( HT_LEVEL_THREE.equals(quota) ) {
    		map.put("minLimit", "1500");
    		map.put("maxLimit", "3500");
    	} else if ( HT_LEVEL_FOUR.equals(quota) ) {
    		map.put("minLimit", "2000");
    		map.put("maxLimit", "3500");
    	} 
    	return map;
    }
    
    
}
