package com.bcxin.risk.policy.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @author LeeJungHyun
 **/
public enum PolicyStatus {
	
	// 撤销
	CANCEL(0, "取消"),
	// 暂存
	DRAFT(1, "暂存"),
	// 核保
	UNDERWRITE(2, "核保"),
	// 撤销
	CANCELED(3, "撤销"),
	// 退保
	SURRENDER(4, "退保"),
	// 复核成功
	APPLIED(5, "已投保"),
	// 生效
	IN_FORCE(9, "生效"),
	// 失效
	LAPSED(12, "失效"),
	// 拒保
	INSURER_REJECTED(14, "拒保"),
	// 延期完成
	DEFER_FINIFH(15, "延期完成");

	public static PolicyStatus convert(String name){
		if ("CANCEL".equals(name)) {
			return CANCEL;
		}if ("DRAFT".equals(name)) {
			return DRAFT;
		}if ("UNDERWRITE".equals(name)) {
			return UNDERWRITE;
		}if ("CANCELED".equals(name)) {
			return CANCELED;
		}if ("SURRENDER".equals(name)) {
			return SURRENDER;
		}if ("APPLIED".equals(name)) {
			return APPLIED;
		}if ("IN_FORCE".equals(name)) {
			return IN_FORCE;
		}if ("LAPSED".equals(name)) {
			return LAPSED;
		}if ("INSURER_REJECTED".equals(name)) {
			return INSURER_REJECTED;
		}if ("DEFER_FINIFH".equals(name)) {
			return DEFER_FINIFH;
		}
		return DRAFT;
	}
	
	private PolicyStatus(int code, String description) {
		this.code = code;
		this.description = description;
	}

	private int code;
	private String description;

	public Integer code() {
		return code;
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	   public static List<PolicyStatus> list(){
		   	List<PolicyStatus> list = new ArrayList<PolicyStatus>();
		   	list.add(DRAFT);
		   	list.add(UNDERWRITE);
		   	list.add(APPLIED);
		   	list.add(IN_FORCE);
		   	list.add(INSURER_REJECTED);
		   	list.add(CANCEL);
		   	return list;
		   }
	
}
