package com.bcxin.risk.order.enums;

/**
 * @Author 管理后台排序
 * 排序
 */
public enum OrderTypeEnum {
    CREATE_DESC("11","创建时间降序"),
    CREATE_ASC("12","创建时间升序"),
    ORDER_DESC("1", "下单日期降序"),
    ORDER_ASC("2", "下单日期升序"),
    DATE_FROM_DESC("3", "距离举办天数降序"),
    DATE_FROM_ASC("4", "距离举办天数升序"),
    ACTIVITY_START_DATE_DESC("5", "活动开始时间降序"),
    ACTIVITY_START_DATE_ASC("6", "活动开始时间升序"),
    ACTIVITY_END_DATE_DESC("7", "活动结束时间降序"),
    ACTIVITY_END_DATE_ASC("8", "活动结束时间升序"),
    ORDER_AMOUNT_DESC("9", "订单金额降序"),
    ORDER_AMOUNT_ASC("10", "订单金额升序");

    private String key;
    private String alias;

    OrderTypeEnum(String key,String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(OrderTypeEnum e : OrderTypeEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
