package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

/**
 * 用户登陆日志表
 */
@Entity
@Table(name = "RISK_UserLoginLog")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class UserLoginLog extends BaseBean {

	private static final long serialVersionUID = 1L;

	private String ipAddress; //登陆ip

	@Temporal(TemporalType.TIMESTAMP)
	private Date loginTime; //登陆时间
	
	private Long user_id; //登陆用户

}
