package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

/**
 * @author hzp
 * 操作日志表
 */
@Entity
@Table(name = "risk_operate_log")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class OperateLog extends BaseBean {

    private Long userId;

    private String operateType;

    private String bizId;

    private String sourceId;

    @Temporal(TemporalType.TIMESTAMP)
    private Date operateTime;

    private String content;

    private String ip;

    /**
     * 成功失败标识
     */
    private String success;

    /**
     * 异常信息
     */
    private String exception;

    private Long activityId;

    private String activityName;

}
