package com.bcxin.risk.expert.dto;

import com.bcxin.risk.enums.ExpertTaskStatusEnum;
import com.bcxin.risk.enums.ExpertTaskTypeEnum;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@Data
public class ExpertOrderPublicDto implements Serializable {

    private String createOn;
    private String orderNo;
    private String activityId;
    private String reportId;
    private String taskId;
    private String activityName;
    private String orgId;
    private String orgName;
    private String taskType;
    private String taskTypeName;
    private String userId;
    private String realName;
    private String taskQuote;
    private String taskStatus;
    private String taskStatusName;
    private String keyword;

    private Page page;

    public ExpertOrderPublicDto(){

    }

    public ExpertOrderPublicDto(Map<String,Object> map){
        this.createOn=safeTransfer(map.get("createOn"));
        this.orderNo=safeTransfer(map.get("orderNo"));
        this.activityId=safeTransfer(map.get("activityId"));
        this.reportId=safeTransfer(map.get("reportId"));
        this.taskId=safeTransfer(map.get("taskId"));
        this.activityName=safeTransfer(map.get("activityName"));
        this.orgId=safeTransfer(map.get("orgId"));
        this.orgName=safeTransfer(map.get("orgName"));
        this.taskType=safeTransfer(map.get("taskType"));
        this.userId=safeTransfer(map.get("userId"));
        this.realName=safeTransfer(map.get("realName"));
        this.taskQuote=safeTransfer(map.get("taskQuote"));
        this.taskStatus=safeTransfer(map.get("taskStatus"));
        this.taskTypeName= ExpertTaskTypeEnum.getAlias(this.taskType);
        this.taskStatusName= ExpertTaskStatusEnum.getAlias(this.taskStatus);
    }
    private String safeTransfer(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}
