package com.bcxin.risk.enums;

/**
 * @author hzp
 * 订单状态
 */
public enum OrderStatusEnum {

    UN_PAY("0","待支付"),
    PAYED("1","已支付"),
    ToBE_PERFECTED("3","待完善"),
    DELAY_PAY("4","延后支付"),
    FINISHED("50","已完结"),
    REFUND("100","已退款"),
    CANCELED("200","已取消");

    private String key;
    private String alias;

    OrderStatusEnum(String key, String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(OrderStatusEnum e : OrderStatusEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
