package com.bcxin.risk.compose.source;

import com.bcxin.risk.base.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 法规信息库
 */
@Entity
@Table(name = "RISK_ComposeRule")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ComposeRule extends BaseBean {

	private static final long serialVersionUID = 1L;

    /**
     * 法规类型
     */
    private String type;

    /**
     * 网址链接
     */
    private String link;

    /**
     * 法规名称
     */
    private String name;

    /**
     * 法规文件
     */
    private String fileUrl;

}
