package com.bcxin.risk.compose.dto;

public class CatalogSeq {

	private int chapterId = 0;
	private int sectionId = 0;
	private int itemId = 0;
	
	public int getChapterId() {
		return chapterId;
	}
	public void setChapterId(int chapterId) {
		this.chapterId = chapterId;
	}
	public int getSectionId() {
		return sectionId;
	}
	public void setSectionId(int sectionId) {
		this.sectionId = sectionId;
	}
	public int getItemId() {
		return itemId;
	}
	public void setItemId(int itemId) {
		this.itemId = itemId;
	}
	public int chapter() {
		++this.chapterId;
		this.sectionId = 0;
		this.itemId = 0;
		return this.chapterId;
	}
	public int section() {
		++this.sectionId;
		this.itemId = 0;
		return this.sectionId;
	}
	public int item() {
		return ++this.itemId;
	}
	public String toString() {
		String seq = "";
		if(chapterId > 0) {
			seq += chapterId;
			if(sectionId > 0) {
				seq += "." + sectionId;
				if(itemId > 0) {
					seq += "." + itemId;
				}
			}
		}
		return seq;
	}
	
}
