package com.bcxin.risk.common.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 同步任务
* 记录每次与第三方系统的同步任务，如果没有同步，则需要定时任务进行同步
* @Description: 
* @date: 2018年05月17日 上午11:10:51
* @author 罗鹏
 */
@Entity
@Table(name = "RISK_SyncTask")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class SyncTask extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 归属的活动编号
	 */
	private String activityNo;

	/**
	 * 同步类型（字典）
	 */
	private String syncTaskType;

	/**
	 * 同步状态是否成功
	 */
	private String success;

	/**
	 * 参数（JSON 字符串）
	 */
	private String param;

}
