package com.bcxin.risk.activity.dto.data;

import com.bcxin.risk.activity.Quotation;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@JsonIgnoreProperties(value={"hibernateLazyInitializer"})
@Data
public class QuotationDTO implements Serializable {

	private String oid;

	private String name;//模板名称

	private String maxQuote; //最高报价

	private String minQuote; //最低报价

	private String quotationType; //定价方式（字典）

	private String active; //是否激活

	private Page page;//分页


	public QuotationDTO(){}


	public QuotationDTO(Map<String,Object> map){
		this.oid = safeTransfor(map.get("oid"));
		this.name = safeTransfor(map.get("name"));
		if ( this.name != null && this.name.length() > 20 ) {
			this.name = this.name.substring(0,20)+"..";
		}
		this.maxQuote = safeTransfor(map.get("maxQuote"));
		this.minQuote = safeTransfor(map.get("minQuote"));
		this.quotationType = safeTransfor(map.get("quotationType"));
		this.active = safeTransfor(map.get("actie"));
	}

	public QuotationDTO(Quotation quotation){
		this.oid = quotation.getOid()+"";
		this.name = quotation.getName();
		if ( this.name != null && this.name.length() > 20 ) {
			this.name = this.name.substring(0,20)+"..";
		}
		this.maxQuote = quotation.getMaxQuote().toString();
		this.minQuote = quotation.getMinQuote().toString();
		this.quotationType = quotation.getQuotationType();
		this.active = quotation.getActive();
	}
	
	
	/**
     * 
     * <b>Function 将Object安全转换为String</b> 
     * 
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}

}
