
package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.math.BigDecimal;


/**
 * 价格模板报价因子
 * @author aluo
 */
@Entity
@Table(name = "risk_quotationFactor")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert
@DynamicUpdate
public class QuotationFactor extends BaseBean {

    /**
     * 具体报价模板
     */
    @ManyToOne(targetEntity = Quotation.class, fetch = FetchType.LAZY, cascade = CascadeType.PERSIST)
    @JoinColumn(name = "quotation_id")
    private Quotation quotation;

    /**
     * 固定价格
     */
    private BigDecimal fixed = BigDecimal.ONE;

    /**
     * 基础价格，默认基础价格为12000
     */
    private BigDecimal base = new BigDecimal("12000");


    private BigDecimal activity_a = BigDecimal.ONE;

    private BigDecimal activity_b = BigDecimal.ONE;

    private BigDecimal activity_c = BigDecimal.ONE;

    private BigDecimal activity_d = BigDecimal.ONE;

    private BigDecimal activity_e = BigDecimal.ONE;

    private BigDecimal activity_f = BigDecimal.ONE;

    private BigDecimal activity_g = BigDecimal.ONE;

    private BigDecimal site_a = BigDecimal.ONE;

    private BigDecimal site_b = BigDecimal.ONE;

    private BigDecimal site_c = BigDecimal.ONE;

    private BigDecimal site_d = BigDecimal.ONE;

    private BigDecimal site_e = BigDecimal.ONE;

    private BigDecimal crowd_a = BigDecimal.ONE;

    private BigDecimal crowd_b = BigDecimal.ONE;

    private BigDecimal crowd_c = BigDecimal.ONE;

    private BigDecimal crowd_d = BigDecimal.ONE;

    private BigDecimal crowd_e = BigDecimal.ONE;

    private BigDecimal crowd_f = BigDecimal.ONE;

    private BigDecimal days_a = BigDecimal.ONE;

    private BigDecimal days_b = BigDecimal.ONE;

    private BigDecimal days_c = BigDecimal.ONE;

    private BigDecimal days_d = BigDecimal.ONE;

    private BigDecimal days_e = BigDecimal.ONE;

    //private BigDecimal risk_a = BigDecimal.ONE;
    //
    //private BigDecimal risk_b = BigDecimal.ONE;
    //
    //private BigDecimal risk_c = BigDecimal.ONE;
    //
    //private BigDecimal risk_d = BigDecimal.ONE;

    private BigDecimal history_a = BigDecimal.ONE;

    private BigDecimal history_b = BigDecimal.ONE;

    private BigDecimal history_c = BigDecimal.ONE;

    private BigDecimal express_a = BigDecimal.ONE;

    private BigDecimal express_c = BigDecimal.ONE;

    private BigDecimal paper_a = BigDecimal.ONE;

    private BigDecimal paper_c = BigDecimal.ONE;

}

    