/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.enums.PushMethodEnum;
import com.bcxin.risk.enums.PushTypeEnum;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="RISK_PUSH_LOG")
@Inheritance(strategy=InheritanceType.JOINED)
@DynamicInsert(value=true)
@DynamicUpdate(value=true)
public class PushLog
extends BaseBean {
    private String batchNo;
    private Date startTime;
    private Date endTime;
    private Long speedTime;
    private int success;
    private int fail;
    private int total;
    private String flag;
    private String msg;
    private String pushType;
    private String pushTypeName;
    private String pushMethod;
    private String paramData;

    public PushLog() {
    }

    public PushLog(PushTypeEnum pushType, PushMethodEnum pushMethod, int total, int fail, int success, String msg, Date start) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Date end = new Date();
        this.setBatchNo("BATCH" + df.format(new Date()));
        this.setCreateOn(new Date());
        this.setFail(fail);
        this.setSuccess(success);
        this.setTotal(total);
        this.setPushType(pushType.getKey());
        this.setPushTypeName(pushType.getAlias());
        this.setStartTime(start);
        this.setEndTime(end);
        this.setSpeedTime(end.getTime() - start.getTime());
        this.setMsg(msg);
        this.setPushMethod(pushMethod.getKey());
        if (success == total) {
            this.setFlag("SUCCESS");
        } else if (fail > 0 && success > 0) {
            this.setFlag("PART SUCCESS");
        } else {
            this.setFlag("FAIL");
        }
    }

    @Generated
    public String getBatchNo() {
        return this.batchNo;
    }

    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getEndTime() {
        return this.endTime;
    }

    @Generated
    public Long getSpeedTime() {
        return this.speedTime;
    }

    @Generated
    public int getSuccess() {
        return this.success;
    }

    @Generated
    public int getFail() {
        return this.fail;
    }

    @Generated
    public int getTotal() {
        return this.total;
    }

    @Generated
    public String getFlag() {
        return this.flag;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public String getPushType() {
        return this.pushType;
    }

    @Generated
    public String getPushTypeName() {
        return this.pushTypeName;
    }

    @Generated
    public String getPushMethod() {
        return this.pushMethod;
    }

    @Generated
    public String getParamData() {
        return this.paramData;
    }

    @Generated
    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setSpeedTime(Long speedTime) {
        this.speedTime = speedTime;
    }

    @Generated
    public void setSuccess(int success) {
        this.success = success;
    }

    @Generated
    public void setFail(int fail) {
        this.fail = fail;
    }

    @Generated
    public void setTotal(int total) {
        this.total = total;
    }

    @Generated
    public void setFlag(String flag) {
        this.flag = flag;
    }

    @Generated
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Generated
    public void setPushType(String pushType) {
        this.pushType = pushType;
    }

    @Generated
    public void setPushTypeName(String pushTypeName) {
        this.pushTypeName = pushTypeName;
    }

    @Generated
    public void setPushMethod(String pushMethod) {
        this.pushMethod = pushMethod;
    }

    @Generated
    public void setParamData(String paramData) {
        this.paramData = paramData;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PushLog)) {
            return false;
        }
        PushLog other = (PushLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSuccess() != other.getSuccess()) {
            return false;
        }
        if (this.getFail() != other.getFail()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        Long this$speedTime = this.getSpeedTime();
        Long other$speedTime = other.getSpeedTime();
        if (this$speedTime == null ? other$speedTime != null : !((Object)this$speedTime).equals(other$speedTime)) {
            return false;
        }
        String this$batchNo = this.getBatchNo();
        String other$batchNo = other.getBatchNo();
        if (this$batchNo == null ? other$batchNo != null : !this$batchNo.equals(other$batchNo)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$flag = this.getFlag();
        String other$flag = other.getFlag();
        if (this$flag == null ? other$flag != null : !this$flag.equals(other$flag)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$pushType = this.getPushType();
        String other$pushType = other.getPushType();
        if (this$pushType == null ? other$pushType != null : !this$pushType.equals(other$pushType)) {
            return false;
        }
        String this$pushTypeName = this.getPushTypeName();
        String other$pushTypeName = other.getPushTypeName();
        if (this$pushTypeName == null ? other$pushTypeName != null : !this$pushTypeName.equals(other$pushTypeName)) {
            return false;
        }
        String this$pushMethod = this.getPushMethod();
        String other$pushMethod = other.getPushMethod();
        if (this$pushMethod == null ? other$pushMethod != null : !this$pushMethod.equals(other$pushMethod)) {
            return false;
        }
        String this$paramData = this.getParamData();
        String other$paramData = other.getParamData();
        return !(this$paramData == null ? other$paramData != null : !this$paramData.equals(other$paramData));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PushLog;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSuccess();
        result = result * 59 + this.getFail();
        result = result * 59 + this.getTotal();
        Long $speedTime = this.getSpeedTime();
        result = result * 59 + ($speedTime == null ? 43 : ((Object)$speedTime).hashCode());
        String $batchNo = this.getBatchNo();
        result = result * 59 + ($batchNo == null ? 43 : $batchNo.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $flag = this.getFlag();
        result = result * 59 + ($flag == null ? 43 : $flag.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $pushType = this.getPushType();
        result = result * 59 + ($pushType == null ? 43 : $pushType.hashCode());
        String $pushTypeName = this.getPushTypeName();
        result = result * 59 + ($pushTypeName == null ? 43 : $pushTypeName.hashCode());
        String $pushMethod = this.getPushMethod();
        result = result * 59 + ($pushMethod == null ? 43 : $pushMethod.hashCode());
        String $paramData = this.getParamData();
        result = result * 59 + ($paramData == null ? 43 : $paramData.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PushLog(batchNo=" + this.getBatchNo() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", speedTime=" + this.getSpeedTime() + ", success=" + this.getSuccess() + ", fail=" + this.getFail() + ", total=" + this.getTotal() + ", flag=" + this.getFlag() + ", msg=" + this.getMsg() + ", pushType=" + this.getPushType() + ", pushTypeName=" + this.getPushTypeName() + ", pushMethod=" + this.getPushMethod() + ", paramData=" + this.getParamData() + ")";
    }
}

