/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.compose.dto;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WordContent
implements Comparable<WordContent> {
    private int seq = 1000;
    private String content = "";
    private Set<String> style = new HashSet<String>();
    private WordContent parent;
    public static final List<String> ignore = new ArrayList<String>();

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content.startsWith("<img>&&") || content.startsWith("<table>&&") ? content : content.replaceAll("<[a-z]*>", "");
    }

    public Set<String> getStyle() {
        return this.style;
    }

    public void setStyle(Set<String> style) {
        this.style = style;
    }

    public WordContent getParent() {
        return this.parent;
    }

    public void setParent(WordContent parent) {
        this.parent = parent;
    }

    public void addStyle(String style) {
        if (!ignore.contains(style)) {
            this.style.add(style);
            if (this.parent != null) {
                this.parent.addStyle(style);
            }
        }
    }

    public static boolean validate(WordContent wordContent) {
        return wordContent != null && (wordContent.getContent().trim().length() != 0 || wordContent.getStyle().size() != 0);
    }

    public String toString() {
        return "WordContent [seq=" + this.seq + ", content=" + this.content + ", style=" + this.style + "]";
    }

    @Override
    public int compareTo(WordContent o) {
        if (this.seq > o.seq) {
            return 1;
        }
        if (this.seq < o.seq) {
            return -1;
        }
        return 0;
    }

    static {
        ignore.add("<p>");
        ignore.add("<div>");
    }
}

