package com.bcxin.event.job.core.domain.utils;

import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import org.apache.commons.lang3.StringUtils;

public class DocumentTypeUtil {
    public static DocumentType translate2CacheableDocumentType(String table) {
        if (StringUtils.isEmpty(table)) {
            return null;
        }

        switch (table) {
            case "tenant_employees":
                return DocumentType.Employee;
            case "tenant_departments":
                return DocumentType.Department;
            case "tenant_organizations":
                return DocumentType.Organization;
            case "tenant_users":
                return DocumentType.User;
            //case "tenant_user_credentials":
            //  return DocumentType.User_Credentials;
            /**
             * 驻勤点发生变更的时候，清除人员对应的驻勤信息的缓存
             */
            case "tlk_attendance_site_base_info":
                return DocumentType.Station_Employee_Set;
            case "tenant_user_credential_details":
                return DocumentType.User_Business_Credentials;
            default:
                return null;
        }
    }
}
