package com.bcxin.event.job.core.domain.dtos;

import lombok.Data;

import java.io.Serializable;

@Data
public class RedisConfig implements Serializable {
    private String host;
    private String password;
    private int port;
    private int timout;

    public static RedisConfig create(String host, int port, int timeout,String password) {
        RedisConfig config = new RedisConfig();
        config.setHost(host);
        config.setPort(port);
        config.setPassword(password);
        config.setTimout(timeout);

        return config;
    }

    /**
     * 记得该方法只能在flink的主方法中调用; 否则系统会因为无法取得System.getProperty的信息而报错
     * @return
     */
    public static RedisConfig getDefaultFromMainThread() {
        String host = System.getProperty("redis.host");
        String port = System.getProperty("redis.port");
        String timout = System.getProperty("redis.timout");
        String password = System.getProperty("redis.password");

        return RedisConfig.create(host, Integer.parseInt(port), Integer.parseInt(timout), password);
    }
}
