package com.bcxin.event.job.core.domain.dtos;

import com.bcxin.event.core.utils.StringUtils;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@Data
public class BinlogMapDTO implements Serializable {
    private String db;
    private String table;
    private DocumentType documentType;
    private String id;
    private String domainId;
    private long syncVersion;


    private Map<String, String> before;
    private Map<String, String> content;

    public boolean isNewVersion(String currentTsVersion) {
        long cVersion = 0;
        try {
            if (StringUtils.hasAlpha(currentTsVersion)) {
                System.err.println(String.format("无效版本信息=%s", cVersion));
                return true;
            }
            cVersion = Long.parseLong(currentTsVersion);
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        /**
         * 允许有点小误差
         * todo: 后续解决
         */
        return this.getSyncVersion() >= cVersion - 30;
    }

    public static BinlogMapDTO create(
            String db,String table,
            String domainId,
            String id,
            long syncVersion,
            DocumentType documentType,
            Map<String, String> content,
            Map<String, String> changedBefore
    ) {
        BinlogMapDTO binlogMapDTO = new BinlogMapDTO();
        binlogMapDTO.setDb(db);
        binlogMapDTO.setTable(table);
        binlogMapDTO.setDocumentType(documentType);
        binlogMapDTO.setContent(content);
        binlogMapDTO.setBefore(changedBefore);
        binlogMapDTO.setSyncVersion(syncVersion);


        binlogMapDTO.setDomainId(domainId);
        binlogMapDTO.setId(id);

        return binlogMapDTO;
    }
}
