package com.bcxin.event.job.core.domain.documents.enums;

import com.bcxin.event.core.exceptions.NoSupportEventException;
import com.bcxin.event.job.core.domain.documents.PersistentStrategy;

public enum DocumentType implements PersistentStrategy {
    Employee {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            return "select * from obpm2.tenant_employees where id=?";
        }
    },
    Organization {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            return "select * from obpm2.tenant_organizations where id=?";
        }
    },
    Department {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            return "select * from obpm2.tenant_departments where id=?";
        }
    },
    User {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            return "select * from obpm2.tenant_users where id=?";
        }
    },
    SecurityStation {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            return "select * from baibaodunflow.tlk_attendance_site_base_info where id=?";
        }
    },
    SecurityStationPerson {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            return "select * from baibaodunflow.tlk_attendance_site_person_info where id=?";
        }
    },

    /**
     * 每个职员拥有的有效驻勤点集合
     */
    Employee_Station_Set {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.None;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            throw new NoSupportEventException();
        }
    },
    /**
     * 每个驻勤点拥有的有效保安人员数量
     */
    Station_Employee_Set {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.None;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            throw new NoSupportEventException();
        }
    },

    /**
     * 每个组织拥有的在职保安人员集合
     */
    Organization_Employee_Set {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            throw new NoSupportEventException();
        }
    },

    /**
     * 当前企业的有效的驻勤点信息
     */
    Organization_Station_Set {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            throw new NoSupportEventException();
        }
    },

    /**
     * 监管归属信息
     */
    SuperviseDepartmentLevel {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            throw new NoSupportEventException();
        }
    },

    /**
     * 监管归属对应的组织信息
     */
    SuperviseDepartmentLevel_ORGANIZATION_SET {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            throw new NoSupportEventException();
        }
    },

    User_Credentials {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            return "select * from obpm2.tenant_user_credentials where id=?";
        }
    },

    Employee_Selected_Security_Station {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            return "SELECT\n" +
                    "\ta.ID,a.ITEM_attendanceSiteName,a.ITEM_officePoliceAddress,a.ITEM_attendanceSiteLongitude,a.ITEM_attendanceSiteLatitude,\n" +
                    "\ta.ITEM_officePoliceAddress,a.ITEM_officePoliceAddressID,a.ITEM_officePoliceIDIndex,a.ID as ATTENDANCESITEID\n" +
                    "FROM\n" +
                    "\tbaibaodunflow.tlk_attendance_site_base_info a\n" +
                    "\tJOIN baibaodunflow.tlk_attendance_site_person_info b ON a.ID = b.ITEM_ATTENDANCESITEID \n" +
                    "WHERE\n" +
                    "\tb.ITEM_SECURITYID=? limit 1";
        }
    },
    /**
     * 针对核验通过之后才进行获取资格证, 等级证, 保安师书信息
     */
    User_Business_Credentials {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            return "SELECT\n" +
                    "\tGROUP_CONCAT( DISTINCT ( case when tucd.certificateType = 2 then CONCAT(IFNULL(tucd.areaCode,''),'$',IFNULL(tucd.appraisalGrade,'')) else '' end ) SEPARATOR ';' ) as dj_level,\n" +
                    "\tGROUP_CONCAT( DISTINCT ( case when tucd.certificateType = 2 then CONCAT(IFNULL(tucd.areaCode,''),'$',IFNULL(tucd.zsbh,'')) else '' end ) SEPARATOR ';' ) as dj_number,\n" +
                    "\tGROUP_CONCAT( DISTINCT ( case when tucd.certificateType = 1 then CONCAT(IFNULL(tucd.areaCode,''),'$',IFNULL(tucd.zsbh,'')) else '' end ) SEPARATOR ';' ) as zgz_number,\n" +
                    "\ttucd.idnum as id_number\n" +
                    "FROM\n" +
                    "\tobpm2.tenant_user_credential_details tucd \n" +
                    "WHERE\n" +
                    "\ttucd.tenant_user_id = ? \n" +
                    "\tAND tucd.certificateType  in ('1','2')\n" +
                    "\tAND tucd.active = 1 \n" +
                    "\tAND tucd.state = '1' limit 1";
        }
    },
    ZsbhByIdCardNo {
        @Override
        public PersistentStrategyType getStrategyType() {
            return PersistentStrategyType.Redis;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public String getFetchSql() {
            return "SELECT CONCAT(IFNULL(areaCode,''),'$',IFNULL(zsbh,'')) as zsbh,idnum as id FROM obpm2.tenant_user_credential_details e where e.idnum =? AND e.certificateType ='1' and e.active = 1 and e.state = '1' limit 1";
        }
    }
}
