package com.bcxin.event.job.core.domain;

import com.bcxin.event.job.core.domain.dtos.RedisConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class JedisPoolFactory {
    private transient static JedisPool jedisPool;
    public static JedisPool getInstance(RedisConfig redisConfig) {
        if (jedisPool != null) {
            return jedisPool;
        }

        synchronized (JedisPoolFactory.class) {
            if (jedisPool == null) {
                JedisPoolConfig config = new JedisPoolConfig();
                config.setMaxTotal(1000);
                config.setMinIdle(2);
                config.setMaxWait(Duration.of(20, ChronoUnit.SECONDS));
                config.setTestOnBorrow(true);

                jedisPool = new JedisPool(config, redisConfig.getHost(), redisConfig.getPort(), redisConfig.getTimout(), redisConfig.getPassword());
            }

            return jedisPool;
        }
    }

    public static Jedis getNewJedisResource(RedisConfig config) {
        Jedis jedis = getInstance(config).getResource();
        jedis.select(3);

        return jedis;
    }
}
