package com.bcxin.event.job.core.domain;

import com.bcxin.event.job.core.domain.documents.enums.DocumentType;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public interface DocumentRepository extends Serializable {

    /**
     * 设置Redis的基本信息
     */
    void upset(DocumentType documentType, Map<String, String> value);

    /**
     * 更改Redis中Hash的属性信息
     * @param documentType
     * @param id
     * @param value
     */
    void update(DocumentType documentType, String id, Map<String, String> value);

    /**
     * 设置集合的相关信息
     */
    void addRelative(DocumentType documentType, String id, Collection<String> relativeIds);
}
