package com.bcxin.event.job.core.domain;

import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import com.bcxin.event.job.core.domain.dtos.BinlogMapDTO;
import com.bcxin.event.job.core.domain.dtos.DocumentExpiredDTO;

import java.sql.Connection;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public interface CacheProvider {

    void upset(BinlogMapDTO data);

    void update(DocumentType documentType, String id, Map<String, String> value);

    void addRelative(DocumentType documentType, String id, Collection<String> relativeIds);

    void removeRelative(DocumentType documentType, String id, Collection<String> relativeIds);

    Map<String, String> getDocument(DocumentType documentType, String id);

    Map<String, String> getDocumentFromCache(DocumentType documentType, String id, DockMapDbExtractor dbExtractor);

    long getSetSize(DocumentType documentType, String id);

    Set<String> getSet(DocumentType documentType, String id);

    void close();

    void expireCache(DocumentType documentType, String id);

    Map<String, String> getDocumentFromCache(DocumentType documentType, String id, DockMapDbExtractor dbExtractor, int cacheInMinutes);

    void expireCache(Collection<DocumentExpiredDTO> documents);
}
