package com.bcxin.event.job.core.domain;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.event.core.FlinkConstants;
import com.bcxin.event.core.utils.DebeziumUtil;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import com.bcxin.event.job.core.domain.dtos.BinlogMapDTO;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BinlogMapTranslator implements Serializable {
    public static BinlogMapDTO translate(JSONObject data) {
        if (data == null || data.isEmpty()) {
            return null;
        }

        JSONObject sourceMap = data.getJSONObject("source");
        String db = sourceMap.getString(DebeziumUtil.META_DB_NAME);
        String table = sourceMap.getString(DebeziumUtil.META_TABLE_NAME);

        DocumentType documentType = null;
        switch (table) {
            case "tenant_employees":
                documentType = DocumentType.Employee;
                break;
            case "tenant_departments":
                documentType = DocumentType.Department;
                break;
            case "tenant_organizations":
                documentType = DocumentType.Organization;
                break;
            case "tenant_users":
                documentType = DocumentType.User;
                break;
            case "tenant_user_credentials":
                documentType = DocumentType.User_Credentials;
                break;
            case "tlk_attendance_site_person_info":
                documentType = DocumentType.SecurityStationPerson;
                break;
            case "tlk_attendance_site_base_info":
                documentType = DocumentType.SecurityStation;
                break;
            default:
                return null;
        }

        JSONObject after = data.getJSONObject("after");
        String id = null;
        String domainId = null;

        Map<String, String> flatMap_after = new HashMap<>();
        if (after == null) {
            //todo 针对删除的操作
        } else {
            id = getKeyValue(after, DebeziumUtil.META_ROW_ID_NAME);
            domainId = getKeyValue(after, DebeziumUtil.META_ROW_DOMAIN_ID_NAME);
            for (String key : after.keySet()) {
                if (after.get(key) != null) {
                    putValue(flatMap_after, key, String.valueOf(after.get(key)));
                }
            }
        }

        JSONObject before = data.getJSONObject("before");
        Map<String, String> flatMap_before = new HashMap<>();
        if (before == null) {
            //todo 针对新增
        } else {
            if (StringUtils.isEmpty(id)) {
                id = getKeyValue(after, DebeziumUtil.META_ROW_ID_NAME);
                domainId = getKeyValue(after, DebeziumUtil.META_ROW_DOMAIN_ID_NAME);
            }

            for (String key : before.keySet()) {
                if (before.get(key) != null) {
                    putValue(flatMap_before, key, String.valueOf(before.get(key)));
                }
            }
        }

        long ts_ms = data.getLong("ts_ms");

        Map<String, String> content = flatMap_after;
        if (content == null || content.isEmpty()) {
            content = flatMap_before;
        }

        return BinlogMapDTO.create(
                db, table, domainId,
                id, ts_ms, documentType,
                content,
                flatMap_before
        );
    }

    private static void putValue(Map<String, String> flatMap, String key, String value) {
        if (StringUtils.isEmpty(key) || value == null) {
            return;
        }

        if (FlinkConstants.isDateTimeField(key)) {
            flatMap.put(key.toLowerCase(), FlinkConstants.formatValue(key, value));
        }

        flatMap.put(key.toLowerCase(), value);
    }

    private static String getKeyValue(JSONObject data, String orgKey) {
        if (data == null || StringUtils.isEmpty(orgKey)) {
            return null;
        }

        Optional<String> mapKeyOptional =
                data.keySet().stream().filter(ix -> ix.equalsIgnoreCase(orgKey) ||
                                (DebeziumUtil.META_ROW_DOMAIN_ID_NAME.equalsIgnoreCase(orgKey) && (ix.equalsIgnoreCase(orgKey) ||
                                        ix.equalsIgnoreCase("organization_id"))))
                        .findFirst();
        if (mapKeyOptional.isPresent()) {
            return data.getString(mapKeyOptional.get());
        }

        return null;
    }
}
