/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.job.core.domain;

import com.bcxin.event.job.core.domain.dtos.RedisConfig;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisPoolFactory {
    private static transient JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JedisPool getInstance(RedisConfig redisConfig) {
        if (jedisPool != null) {
            return jedisPool;
        }
        Class<JedisPoolFactory> clazz = JedisPoolFactory.class;
        synchronized (JedisPoolFactory.class) {
            if (jedisPool == null) {
                JedisPoolConfig config = new JedisPoolConfig();
                config.setMaxTotal(1000);
                config.setMinIdle(2);
                config.setMaxWait(Duration.of(20L, ChronoUnit.SECONDS));
                config.setTestOnBorrow(true);
                jedisPool = new JedisPool((GenericObjectPoolConfig)config, redisConfig.getHost(), redisConfig.getPort(), redisConfig.getTimout(), redisConfig.getPassword());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return jedisPool;
        }
    }

    public static Jedis getNewJedisResource(RedisConfig config) {
        Jedis jedis = JedisPoolFactory.getInstance(config).getResource();
        jedis.select(3);
        return jedis;
    }
}

