{
  "properties" : { },
  "id" : "1c250dd68348438ba65e28081923a8bd",
  "script" : null,
  "groupId" : "05b429d9d76e469eb86e3e7ab55eb0fd",
  "name" : "指挥调度数量统计",
  "createTime" : null,
  "updateTime" : 1698027014934,
  "lock" : null,
  "createBy" : null,
  "updateBy" : null,
  "path" : "/countDispatch",
  "method" : "GET",
  "parameters" : [ {
    "name" : "isFirst",
    "value" : "0",
    "description" : null,
    "required" : false,
    "dataType" : "String",
    "type" : null,
    "defaultValue" : null,
    "validateType" : null,
    "error" : null,
    "expression" : null,
    "children" : null
  }, {
    "name" : "region",
    "value" : "#1",
    "description" : null,
    "required" : false,
    "dataType" : "String",
    "type" : null,
    "defaultValue" : null,
    "validateType" : null,
    "error" : null,
    "expression" : null,
    "children" : null
  } ],
  "options" : [ ],
  "requestBody" : "",
  "headers" : [ ],
  "paths" : [ ],
  "responseBody" : "{\n    \"code\": 1,\n    \"message\": \"success\",\n    \"data\": [\n        {\n            \"类型\": \"今日\",\n            \"音频调度人数\": 1,\n            \"调度调度人数\": 1\n        },\n        {\n            \"类型\": \"近七天\",\n            \"音频调度人数\": 10,\n            \"调度调度人数\": 8\n        },\n        {\n            \"类型\": \"近一个月\",\n            \"音频调度人数\": 17,\n            \"调度调度人数\": 11\n        }\n    ],\n    \"timestamp\": 1698026991018,\n    \"executeTime\": 116\n}",
  "description" : null,
  "requestBodyDefinition" : null,
  "responseBodyDefinition" : null
}
================================
var sql = """
SELECT
    "今日" as 类型,
    COUNT(DISTINCT CASE WHEN ITEM_TYPE = '0' THEN ITEM_CALLED_USER_ID END) AS 音频调度人数,
    COUNT(DISTINCT CASE WHEN ITEM_TYPE = '1' THEN ITEM_CALLED_USER_ID END) AS 调度调度人数
FROM
    dispatch.tlk_device_comminicated_logs_detail d
	left join
	dispatch.rd_employee_summary e on d.ITEM_CALLER_USER_ID=e.id
WHERE
    ITEM_CREATED_TIME >= CURDATE() -- 今日
	?{isFirst!=null&&isFirst!='1', and e.supervise_depart_name like CONCAT('%',#{region},'%') }
	
UNION
SELECT
    "近七天" as 类型,
    COUNT(DISTINCT CASE WHEN ITEM_TYPE = '0' THEN ITEM_CALLED_USER_ID END) AS 音频调度人数,
    COUNT(DISTINCT CASE WHEN ITEM_TYPE = '1' THEN ITEM_CALLED_USER_ID END) AS 调度调度人数
FROM
    dispatch.tlk_device_comminicated_logs_detail d
	left join
	dispatch.rd_employee_summary e on d.ITEM_CALLER_USER_ID=e.id
WHERE
    ITEM_CREATED_TIME >= DATE_SUB(CURDATE(), INTERVAL 7 DAY) -- 近七天
	?{isFirst!=null&&isFirst!='1', and e.supervise_depart_name like CONCAT('%',#{region},'%') }
UNION
SELECT
    "近一个月" as 类型,
    COUNT(DISTINCT CASE WHEN ITEM_TYPE = '0' THEN ITEM_CALLED_USER_ID END) AS 音频调度人数,
    COUNT(DISTINCT CASE WHEN ITEM_TYPE = '1' THEN ITEM_CALLED_USER_ID END) AS 调度调度人数
FROM
    dispatch.tlk_device_comminicated_logs_detail d
	left join
	dispatch.rd_employee_summary e on d.ITEM_CALLER_USER_ID=e.id
WHERE
    ITEM_CREATED_TIME >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH) -- 近一个月
	?{isFirst!=null&&isFirst!='1', and e.supervise_depart_name like CONCAT('%',#{region},'%') }
"""
return db.cache('one-countDispatch-' + region, 1000 * 60 * 1).select(sql)