package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.huifu.TransactionLog;
import com.zbkj.service.dao.TransactionLogDao;
import com.zbkj.service.service.TransactionLogService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * TransactionLogServiceImpl 接口实现
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
@Service
public class TransactionLogServiceImpl extends ServiceImpl<TransactionLogDao, TransactionLog> implements TransactionLogService {

    @Resource
    private TransactionLogDao dao;

    public TransactionLog order(String orderNo){
        LambdaQueryWrapper<TransactionLog> lqw = Wrappers.lambdaQuery();
        lqw.eq(TransactionLog::getKeyNo, orderNo);
        List<TransactionLog> list = dao.selectList(lqw);
        return list.get(0);
    }

    public void save(String tradeType,String tradeStatus,String request,String response){
        try {
            TransactionLog log = new TransactionLog();
            log.setTradeType(tradeType);
            log.setTradeStatus(tradeStatus);
            log.setRequestMessage(request);
            log.setResponseMessage(response);
            log.setCreateTime(DateUtil.date());
            new Thread(() ->
                    dao.insert(log)
            ).start();
        } catch (Exception e){
            e.printStackTrace();
        }
    }

}

