package com.zbkj.service.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxSettleBill;
import com.zbkj.common.request.BcxBillGenerateSettleRequest;
import com.zbkj.common.request.BcxSettleBillSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxSettleBillInfoResponse;
import com.zbkj.common.response.BcxSettleBillDetailResponse;
import com.zbkj.common.response.BcxSettleBillResponse;
import com.zbkj.common.response.BcxSettleBillStatisticsResponse;

import java.text.ParseException;
import java.util.Date;

/**
 * description: 业绩账单表 服务接口
 * author : linchunpeng
 * date : 2023/8/3
 */
public interface BcxSettleBillService extends IService<BcxSettleBill> {

    /**
     * description：生成业绩账单
     * author：linchunpeng
     * date：2023/8/17
     */
    void generateSettleBill(Date endTime);

    /**
     * description：根据id，查询账单
     * author：linchunpeng
     * date：2023/8/17
     */
    BcxSettleBillDetailResponse findId(Long id);

    /**
     * description：查询业绩账单
     * author：linchunpeng
     * date：2023/8/15
     */
    PageInfo<BcxSettleBillResponse> getPage(BcxSettleBillSearchRequest request, PageParamRequest pageParamRequest) throws ParseException;

    /**
     * description：业绩账单统计
     * author：linchunpeng
     * date：2024/3/28
     */
    BcxSettleBillStatisticsResponse statistics(BcxSettleBillSearchRequest request) throws ParseException;

    /**
     * description：获取生成结算单数据
     * author：linchunpeng
     * date：2023/8/22
     */
    BcxSettleBillInfoResponse getSettleInfo(BcxBillGenerateSettleRequest request);

    /**
     * description：生成结算单
     * author：linchunpeng
     * date：2023/8/22
     */
    Boolean generateSettle(BcxBillGenerateSettleRequest request);
}