package com.zbkj.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zbkj.common.dto.HuifuWalletAccountDetailDto;
import com.zbkj.common.model.huifu.HuifuWalletAccountDetail;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 企业钱包账户明细
 *
 * @author lp
 * @date 2019-12-10
 */
public interface HuifuWalletAccountDetailDao extends BaseMapper<HuifuWalletAccountDetail> {

    /**
     * 批量插入
     */
    int insertBatch(@Param("detailList") List<HuifuWalletAccountDetailDto> detailList);

    List<HuifuWalletAccountDetail> selectByWalletNoAndDate(@Param("walletNo") String walletNo,
                                                           @Param("startDate") String startDate,
                                                           @Param("endDate") String endDate);

    List<HuifuWalletAccountDetail> selectByUniIdAndDate(@Param("uniId") String uniId,
                                                      @Param("startDate") String startDate,
                                                      @Param("endDate") String endDate,
                                                      @Param("isHideCheck") String isHideCheck);
    HuifuWalletAccountDetail geAccountDetailByTradeFlowNo(@Param("tradeFlowNo") String tradeFlowNo,
                                      @Param("uniId") String uniId);

    List<String> selectFlowNoByDate(@Param("startDate") String startDate,
                                    @Param("endDate") String endDate);

    int checkFlowNo(@Param("tradeFlowNo") String tradeFlowNo,
                                    @Param("uniId") String uniId);

    String getVoucherUrlByFlowNo(@Param("flowNo") String flowNo,
                                 @Param("uniId") String uniId);

    /**
     * <b> 查询电子回单地址 </b>
     * @author ZXF
     * @create 2023/05/25 0025 14:48
     * @version
     * @注意事项 </b>
     */
    String getVoucherUrlByTradeFlowNo(@Param("tradeFlowNo") String tradeFlowNo,
                                      @Param("uniId") String uniId);
    /**
     * <b> 查询交易日期 yyyyMMdd </b>
     * @author ZXF
     * @create 2023/05/25 0025 14:49
     * @version
     * @注意事项 </b>
     */
    String getTradeDateByTradeFlowNo(@Param("tradeFlowNo") String tradeFlowNo,
                                      @Param("uniId") String uniId);

    /**
     * <b> 查询入账方保证金账户号 </b>
     * @author ZXF
     * @create 2023/05/25 0025 14:49
     * @version
     * @注意事项 </b>
     */
    String getAccountInByTradeFlowNo(@Param("tradeFlowNo") String tradeFlowNo,
                                      @Param("uniId") String uniId);

    int updateVoucherUrl(@Param("tradeFlowNo")String tradeFlowNo,@Param("voucherUrl")String voucherUrl);
    int updateVoucherUrlById(@Param("id") Integer id,@Param("voucherUrl")String voucherUrl,@Param("tradeFlowNo")String tradeFlowNo);

}