package com.zbkj.common.response.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单发票明细响应对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxOrderFapiaoResponse对象", description = "订单发票明细响应对象")
public class BcxOrderFapiaoResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "订单发票id")
    private Integer id;

    @ApiModelProperty(value = "用户id")
    private Integer uid;

    @ApiModelProperty(value = "用户名称")
    private String userName;

    @ApiModelProperty(value = "商户id")
    private Integer merId;

    @ApiModelProperty(value = "订单号，多个以小写,号隔开")
    private String orderNo;

    @ApiModelProperty(value = "0-个人 1-企业")
    private Integer titleType;

    @ApiModelProperty(value = "0-增值税普通 1-增值税专用")
    private Integer fapiaoType;

    @ApiModelProperty(value = "发票抬头")
    private String title;

    @ApiModelProperty(value = "发票金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "税号")
    private String taxNo;

    @ApiModelProperty(value = "邮箱")
    private String email;

    @ApiModelProperty(value = "开户银行")
    private String bankName;

    @ApiModelProperty(value = "银行账号")
    private String bankAccount;

    @ApiModelProperty(value = "企业地址")
    private String address;

    @ApiModelProperty(value = "企业电话")
    private String phone;

    @ApiModelProperty(value = "0-未开 1-已开发票")
    private Integer fapiaoStatus;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "申请单号,流水号")
    private String applyNo;

    @ApiModelProperty(value = "发票号码")
    private String fapiaoNo;

    @ApiModelProperty(value = "申请时间")
    private Date applyTime;

    @ApiModelProperty(value = "开票时间")
    private Date writeTime;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "商品类型")
    private Integer bizType;

    @ApiModelProperty(value = "商品信息")
    private String productInfo;
}
