package com.zbkj.common.response;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 平台端订单分页列表响应对象
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "PlatformOrderPageResponse对象", description = "平台端订单分页列表响应对象")
public class PlatformOrderPageResponse extends CommonOrderPageResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "商户名称")
    @ColumnWidth(50)
    @ExcelProperty(value = "商户名称", order = 1)
    private String merName;

    @ApiModelProperty(value = "用户名称")
    @ColumnWidth(50)
    @ExcelProperty(value = "用户", order = 3)
    private String userName;

    @ApiModelProperty(value = "服务人员名称,号隔开")
    @ColumnWidth(50)
    @ExcelProperty(value = "服务人员", order = 5)
    private String memberName;

    @ApiModelProperty(value = "商户是否删除")
    @ExcelIgnore
    private Boolean isMerchantDel;
    @ExcelProperty("商户是否删除")
    private String isMerchantDelStr;

    public String getIsMerchantDelStr() {
        if (isMerchantDel == null) {
            return "";
        }
        return isMerchantDel ? "是" : "否";
    }
}
