package com.zbkj.common.response;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.zbkj.common.utils.DateConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "CommonRefundOrderPageResponse对象", description = "通用退款订单分页列表响应对象")
public class CommonRefundOrderPageResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "退款订单号")
    @ColumnWidth(50)
    @ExcelProperty(value = "退款订单号", index = 1)
    private String refundOrderNo;

    @ApiModelProperty(value = "主订单号")
    @ColumnWidth(50)
    @ExcelProperty(value = "主订单号", index = 3)
    private String orderNo;

    @ApiModelProperty(value = "用户id")
    @ExcelIgnore
    private Integer uid;

    @ApiModelProperty(value = "用户昵称")
    @ColumnWidth(50)
    @ExcelProperty(value = "用户昵称", index = 7)
    private String userNickName;

    @ApiModelProperty(value = "商品名称")
    @ColumnWidth(50)
    @ExcelProperty(value = "商品名称", index = 9)
    private String productName;

    @ApiModelProperty(value = "订单商品总数")
    @ColumnWidth(50)
    @ExcelProperty("订单商品总数")
    private Integer totalNum;

    @ApiModelProperty(value = "退款原因")
    @ColumnWidth(50)
    @ExcelProperty("退款原因")
    private String refundReasonWap;

    @ApiModelProperty(value = "退款图片")
    private String refundReasonWapImg;

    @ApiModelProperty(value = "退款用户说明")
    @ColumnWidth(50)
    @ExcelProperty("退款用户说明")
    private String refundReasonWapExplain;

    @ApiModelProperty(value = "退款状态：0:待审核 1:审核未通过 2：退款中 3:已退款")
    @ExcelIgnore
    private Integer refundStatus;
    @ColumnWidth(50)
    @ExcelProperty("退款状态")
    private String refundStatusStr;

    public String getRefundStatusStr() {
        if (this.refundStatus == 0) {
            return "待审核";
        } else if (this.refundStatus == 1) {
            return "审核未通过";
        } else if (this.refundStatus == 2) {
            return "退款中";
        } else if (this.refundStatus == 3) {
            return "已退款";
        }
        return "";
    }

    @ApiModelProperty(value = "拒绝退款说明")
    @ColumnWidth(50)
    @ExcelProperty("拒绝退款说明")
    private String refundReason;

    @ApiModelProperty(value = "退款金额")
    @ColumnWidth(50)
    @ExcelProperty("退款金额")
    private BigDecimal refundPrice;

    @ApiModelProperty(value = "退款时间")
    @ColumnWidth(50)
    @ExcelProperty(value = "退款时间", converter = DateConverter.class)
    private Date refundTime;

    @ApiModelProperty(value = "商户备注")
    @ColumnWidth(50)
    @ExcelProperty("商户备注")
    private String merRemark;

    @ApiModelProperty(value = "创建时间")
    @ColumnWidth(50)
    @ExcelProperty(value = "创建时间", converter = DateConverter.class)
    private Date createTime;
}
