package com.zbkj.common.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * description: 结算单详情 response对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxSettleDetailResponse对象", description = "结算单详情 response对象")
public class BcxSettleDetailResponse implements Serializable {

    @ApiModelProperty(value = "结算单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "账期，yyyy-MM")
    private String billPeriod;

    @ApiModelProperty(value = "结算单号")
    private String settleNo;

    @ApiModelProperty(value = "结算数量")
    private Integer reportCount;

    @ApiModelProperty(value = "实付总金额")
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "佣金总金额")
    private BigDecimal brokerageTotalPrice;

    @ApiModelProperty(value = "结算状态：1待结算，2已结算")
    private Integer settleStatus;

    @ApiModelProperty(value = "支付方式：1线下结算，2企业钱包结算，3第三方支付结算")
    private Integer payWay;

    @ApiModelProperty(value = "结算时间")
    private Date settleTime;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;


    @ApiModelProperty(value = "关联id：渠道表id，部门表id，部门成员表id，用户表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long belongId;

    @ApiModelProperty(value = "关联类型：1渠道表，2部门表，3部门成员表，4用户表-分销商，5用户表-分销员")
    private Integer belongType;

    @ApiModelProperty(value = "结算对象")
    private String settleName;

}