/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zbkj.common.constants.WeChatConstants;
import com.zbkj.common.enums.PayComponentCatStatusEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.wechat.video.PayComponentCat;
import com.zbkj.common.request.wxvedio.image.ShopUploadImgRequest;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.utils.WxUtil;
import com.zbkj.common.vo.wxvedioshop.WechatVideoUploadImageResponseVo;
import com.zbkj.common.vo.wxvedioshop.audit.ShopAuditBrandRequestItemDataVo;
import com.zbkj.common.vo.wxvedioshop.audit.ShopAuditBrandRequestItemVo;
import com.zbkj.common.vo.wxvedioshop.audit.ShopAuditBrandRequestVo;
import com.zbkj.common.vo.wxvedioshop.audit.ShopAuditBrandResponseVo;
import com.zbkj.common.vo.wxvedioshop.audit.ShopAuditCategoryRequestVo;
import com.zbkj.common.vo.wxvedioshop.audit.ShopAuditCategoryResponseVo;
import com.zbkj.common.vo.wxvedioshop.audit.ShopAuditGetMiniAppCertificateRequestVo;
import com.zbkj.common.vo.wxvedioshop.audit.ShopAuditResultCategoryAndBrandRequestVo;
import com.zbkj.common.vo.wxvedioshop.audit.ShopAuditResultResponseVo;
import com.zbkj.service.service.PayComponentCatService;
import com.zbkj.service.service.WechatService;
import com.zbkj.service.service.WechatVideoBeforeService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Service
public class WechatVideoBeforeServiceImpl
implements WechatVideoBeforeService {
    private static final Logger logger = LoggerFactory.getLogger(WechatVideoBeforeServiceImpl.class);
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private PayComponentCatService payComponentCatService;

    @Override
    public WechatVideoUploadImageResponseVo shopImgUpload(ShopUploadImgRequest request) {
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"resp_type", (Object)request.getRespType());
        params.add((Object)"upload_type", (Object)request.getUploadType());
        params.add((Object)"img_url", (Object)request.getImgUrl());
        String uploadResult = this.restTemplateUtil.postFormData(StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_IMG_UPLOAD, (Object[])new Object[]{miniAccessToken}), params);
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6--\u300b\u4e0a\u4f20\u56fe\u7247 --\u300b" + uploadResult);
        return (WechatVideoUploadImageResponseVo)JSONObject.parseObject((String)uploadResult, WechatVideoUploadImageResponseVo.class);
    }

    @Override
    public ShopAuditBrandResponseVo shopAuditBrand(ShopAuditBrandRequestVo requestVo) {
        Map<String, Object> brandMap = this.assembleAuditBrandMap(requestVo);
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_AUDIT_AUDIT_BRAND, (Object[])new Object[]{miniAccessToken});
        String postStringData = this.restTemplateUtil.postStringData(url, JSONObject.toJSONString(brandMap));
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 --> \u4e0a\u4f20\u54c1\u724c\u4fe1\u606f \u53c2\u6570-->" + postStringData);
        JSONObject jsonObject = JSONObject.parseObject((String)postStringData);
        WxUtil.checkResult((JSONObject)jsonObject);
        ShopAuditBrandResponseVo brandResponseVo = (ShopAuditBrandResponseVo)JSONObject.parseObject((String)postStringData, ShopAuditBrandResponseVo.class);
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 --> \u4e0a\u4f20\u54c1\u724c\u4fe1\u606f \u7ed3\u679c-->" + JSON.toJSONString((Object)brandResponseVo));
        return brandResponseVo;
    }

    private Map<String, Object> assembleAuditBrandMap(ShopAuditBrandRequestVo requestVo) {
        HashMap map = CollUtil.newHashMap();
        HashMap reqMap = CollUtil.newHashMap();
        HashMap infoMap = CollUtil.newHashMap();
        ShopAuditBrandRequestItemVo requestItemVo = requestVo.getAuditReq();
        ShopAuditBrandRequestItemDataVo brandInfo = requestItemVo.getBrandInfo();
        infoMap.put("brand_audit_type", brandInfo.getBrandAuditType());
        infoMap.put("trademark_type", brandInfo.getTrademarkType());
        infoMap.put("brand_management_type", brandInfo.getBrandManagementType());
        infoMap.put("commodity_origin_type", brandInfo.getCommodityOriginType());
        infoMap.put("brand_wording", brandInfo.getBrandWording());
        if (CollUtil.isNotEmpty((Collection)brandInfo.getTrademarkChangeCertificate())) {
            infoMap.put("trademark_change_certificate", brandInfo.getTrademarkChangeCertificate());
        }
        infoMap.put("trademark_registrant_nu", brandInfo.getTrademarkRegistrantNu());
        if (CollUtil.isNotEmpty((Collection)brandInfo.getImportedGoodsForm())) {
            infoMap.put("imported_goods_form", brandInfo.getImportedGoodsForm());
        }
        switch (brandInfo.getBrandAuditType()) {
            case 1: {
                infoMap.put("trademark_registration_certificate", brandInfo.getTrademarkRegistrationCertificate());
                infoMap.put("trademark_registrant", brandInfo.getTrademarkRegistrant());
                infoMap.put("trademark_authorization_period", brandInfo.getTrademarkAuthorizationPeriod());
                break;
            }
            case 2: {
                infoMap.put("trademark_registration_application", brandInfo.getTrademarkRegistrationApplication());
                infoMap.put("trademark_applicant", brandInfo.getTrademarkApplicant());
                infoMap.put("trademark_application_time", brandInfo.getTrademarkApplicationTime());
                break;
            }
            case 3: {
                infoMap.put("sale_authorization", brandInfo.getSaleAuthorization());
                infoMap.put("trademark_registration_certificate", brandInfo.getTrademarkRegistrationCertificate());
                infoMap.put("trademark_registrant", brandInfo.getTrademarkRegistrant());
                infoMap.put("trademark_authorization_period", brandInfo.getTrademarkAuthorizationPeriod());
                break;
            }
            case 4: {
                infoMap.put("sale_authorization", brandInfo.getSaleAuthorization());
                infoMap.put("trademark_registration_application", brandInfo.getTrademarkRegistrationApplication());
                infoMap.put("trademark_applicant", brandInfo.getTrademarkApplicant());
                infoMap.put("trademark_application_time", brandInfo.getTrademarkApplicationTime());
                break;
            }
            default: {
                infoMap.put("sale_authorization", brandInfo.getSaleAuthorization());
                infoMap.put("trademark_registration_certificate", brandInfo.getTrademarkRegistrationCertificate());
                infoMap.put("trademark_registrant", brandInfo.getTrademarkRegistrant());
                infoMap.put("trademark_authorization_period", brandInfo.getTrademarkAuthorizationPeriod());
                infoMap.put("trademark_registration_application", brandInfo.getTrademarkRegistrationApplication());
                infoMap.put("trademark_applicant", brandInfo.getTrademarkApplicant());
                infoMap.put("trademark_application_time", brandInfo.getTrademarkApplicationTime());
            }
        }
        reqMap.put("license", requestItemVo.getLicense());
        reqMap.put("brand_info", infoMap);
        map.put("audit_req", reqMap);
        return map;
    }

    @Override
    public ShopAuditCategoryResponseVo shopAuditCategory(ShopAuditCategoryRequestVo requestVo) {
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6--\u300b\u4e0a\u4f20\u7c7b\u76ee\u8d44\u8d28--\u300b\u8bf7\u6c42\u53c2\u6570--\u300b" + JSON.toJSONString((Object)requestVo));
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String postStringData = this.restTemplateUtil.postStringData(StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_AUDIT_AUDIT_CATEGORY, (Object[])new Object[]{miniAccessToken}), JSONObject.toJSONString((Object)requestVo));
        ShopAuditCategoryResponseVo resultForAuditCat = (ShopAuditCategoryResponseVo)JSONObject.parseObject((String)postStringData, ShopAuditCategoryResponseVo.class);
        if (!resultForAuditCat.getErrcode().equals(0)) {
            throw new CrmebException("\u63d0\u4ea4\u5ba1\u6838\u5931\u8d25:" + resultForAuditCat.getErrmsg());
        }
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(PayComponentCat::getThirdCatId, (Object)requestVo.getAudit_req().getCategory_info().getLevel3());
        lambdaUpdateWrapper.set(PayComponentCat::getStatus, (Object)PayComponentCatStatusEnum.WECHAT_REVIEW_ING.getCode());
        lambdaUpdateWrapper.set(PayComponentCat::getAuditTime, (Object)CrmebDateUtil.nowDateTime());
        lambdaUpdateWrapper.set(PayComponentCat::getAuditId, (Object)resultForAuditCat.getAudit_id());
        lambdaUpdateWrapper.set(PayComponentCat::getAuditQualificationReq, (Object)JSON.toJSONString((Object)requestVo));
        this.payComponentCatService.update((Wrapper)lambdaUpdateWrapper);
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6--\u300b\u4e0a\u4f20\u7c7b\u76ee\u8d44\u8d28--\u300b\u7ed3\u679c--\u300b" + postStringData);
        return resultForAuditCat;
    }

    @Override
    public ShopAuditResultResponseVo shopAuditResult(ShopAuditResultCategoryAndBrandRequestVo request) {
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String postStringData = this.restTemplateUtil.postStringData(StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_AUDIT_RESULT, (Object[])new Object[]{miniAccessToken}), JSONObject.toJSONString((Object)request));
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6--\u300b\u83b7\u53d6\u7c7b\u76ee\u5ba1\u6838\u7ed3\u679c--\u300b\u7ed3\u679c--\u300b" + postStringData);
        JSONObject jsonObjectResult = JSON.parseObject((String)postStringData);
        WxUtil.checkResult((JSONObject)jsonObjectResult);
        JSONObject auditDataResult = jsonObjectResult.getJSONObject("data");
        this.payComponentCatService.getAuditResultOrAuditCallBack(auditDataResult, request.getAudit_id());
        return (ShopAuditResultResponseVo)JSONObject.parseObject((String)postStringData, ShopAuditResultResponseVo.class);
    }

    @Override
    public ShopAuditGetMiniAppCertificateRequestVo shopAuditGetMinCertificate(ShopAuditGetMiniAppCertificateRequestVo request) {
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String postStringData = this.restTemplateUtil.postStringData(StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_AUDIT_GET_MINIAPP_CERTIFICATE, (Object[])new Object[]{miniAccessToken}), JSONObject.toJSONString((Object)request));
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6--\u300b\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u8d44\u8d28--\u300b\u7ed3\u679c--\u300b" + postStringData);
        return (ShopAuditGetMiniAppCertificateRequestVo)JSONObject.parseObject((String)postStringData, ShopAuditGetMiniAppCertificateRequestVo.class);
    }

    @Override
    public WechatVideoUploadImageResponseVo shopImgUploadTest(MultipartFile file, Integer respType, Integer uploadType, String imgUrl) {
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"resp_type", (Object)respType);
        params.add((Object)"upload_type", (Object)uploadType);
        if (StrUtil.isNotBlank((CharSequence)imgUrl)) {
            params.add((Object)"img_url", (Object)imgUrl);
        }
        params.add((Object)"file", (Object)file);
        String uploadResult = this.restTemplateUtil.postFormData(StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_IMG_UPLOAD, (Object[])new Object[]{miniAccessToken}), params);
        return (WechatVideoUploadImageResponseVo)JSONObject.parseObject((String)uploadResult, WechatVideoUploadImageResponseVo.class);
    }
}

