/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.BalanceRecordConstants;
import com.zbkj.common.constants.BillConstants;
import com.zbkj.common.constants.GroupDataConstants;
import com.zbkj.common.constants.UserConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bill.Bill;
import com.zbkj.common.model.order.RechargeOrder;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBalanceRecord;
import com.zbkj.common.model.user.UserToken;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.RechargeOrderSearchRequest;
import com.zbkj.common.request.UserRechargeRequest;
import com.zbkj.common.response.OrderPayResultResponse;
import com.zbkj.common.response.RechargePackageResponse;
import com.zbkj.common.response.UserRechargeItemResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RequestUtil;
import com.zbkj.common.utils.WxPayUtil;
import com.zbkj.common.vo.AttachVo;
import com.zbkj.common.vo.CreateOrderH5SceneInfoDetailVo;
import com.zbkj.common.vo.CreateOrderH5SceneInfoVo;
import com.zbkj.common.vo.CreateOrderRequestVo;
import com.zbkj.common.vo.CreateOrderResponseVo;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.WxPayJsResultVo;
import com.zbkj.service.dao.RechargeOrderDao;
import com.zbkj.service.service.AliPayService;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.BillService;
import com.zbkj.service.service.RechargeOrderService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemGroupDataService;
import com.zbkj.service.service.UserBalanceRecordService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserTokenService;
import com.zbkj.service.service.WechatService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class RechargeOrderServiceImpl
extends ServiceImpl<RechargeOrderDao, RechargeOrder>
implements RechargeOrderService {
    @Resource
    private RechargeOrderDao dao;
    private static final Logger logger = LoggerFactory.getLogger(RechargeOrderServiceImpl.class);
    @Autowired
    private UserService userService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private SystemGroupDataService systemGroupDataService;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private UserTokenService userTokenService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private UserBalanceRecordService userBalanceRecordService;
    @Autowired
    private BillService billService;
    @Autowired
    @Lazy
    private AsyncService asyncService;
    @Autowired
    private AliPayService aliPayService;

    @Override
    public PageInfo<RechargeOrder> getAdminPage(RechargeOrderSearchRequest request, PageParamRequest pageParamRequest) {
        DateLimitUtilVo dateLimit;
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        if (ObjectUtil.isNotNull((Object)request.getUid()) && request.getUid() > 0) {
            lqw.eq(RechargeOrder::getUid, (Object)request.getUid());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            lqw.like(RechargeOrder::getOrderNo, (Object)keywords);
        }
        lqw.eq(RechargeOrder::getPaid, (Object)true);
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit()) && StrUtil.isNotBlank((CharSequence)(dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit())).getStartTime()) && StrUtil.isNotBlank((CharSequence)dateLimit.getEndTime())) {
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            lqw.between(RechargeOrder::getCreateTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        lqw.orderByDesc(RechargeOrder::getId);
        List rechargeOrderList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)rechargeOrderList)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new RechargeOrder[0]));
        }
        List<Integer> userIds = rechargeOrderList.stream().map(RechargeOrder::getUid).collect(Collectors.toList());
        Map<Integer, User> userHashMap = this.userService.getUidMapList(userIds);
        rechargeOrderList.forEach(e -> {
            User user = (User)userHashMap.get(e.getUid());
            e.setAvatar(user.getAvatar());
            e.setNickname(user.getNickname());
        });
        return CommonPage.copyPageInfo((Page)page, (List)rechargeOrderList);
    }

    @Override
    public RechargePackageResponse getRechargePackage() {
        RechargePackageResponse userRechargeResponse = new RechargePackageResponse();
        userRechargeResponse.setPackageList(this.systemGroupDataService.getListByGid(GroupDataConstants.GROUP_DATA_ID_RECHARGE_PACKAGE, UserRechargeItemResponse.class));
        String rechargeAttention = this.systemConfigService.getValueByKey("recharge_attention");
        List rechargeAttentionList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)rechargeAttention)) {
            rechargeAttentionList = CrmebUtil.stringToArrayStrRegex((String)rechargeAttention, (String)"\n");
        }
        userRechargeResponse.setNoticeList(rechargeAttentionList);
        return userRechargeResponse;
    }

    @Override
    public OrderPayResultResponse userRechargeOrderCreate(UserRechargeRequest request) {
        BigDecimal rechargeMinAmount;
        User user = this.userService.getInfo();
        if (ObjectUtil.isNull((Object)request.getPrice()) && ObjectUtil.isNull((Object)request.getGroupDataId())) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u5145\u503c\u5957\u9910\u6216\u586b\u5199\u81ea\u5b9a\u4e49\u5145\u503c\u91d1\u989d");
        }
        BigDecimal rechargePrice = BigDecimal.ZERO;
        BigDecimal gainPrice = BigDecimal.ZERO;
        String rechargeMinAmountStr = this.systemConfigService.getValueByKey("store_user_min_recharge");
        BigDecimal bigDecimal = rechargeMinAmount = StrUtil.isBlank((CharSequence)rechargeMinAmountStr) ? BigDecimal.ZERO : new BigDecimal(rechargeMinAmountStr);
        if (ObjectUtil.isNotNull((Object)request.getPrice())) {
            if (request.getPrice().compareTo(BigDecimal.ZERO) <= 0) {
                throw new CrmebException("\u5145\u503c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            rechargePrice = request.getPrice();
        } else {
            UserRechargeItemResponse rechargePackage = this.systemGroupDataService.getNormalInfo(request.getGroupDataId(), UserRechargeItemResponse.class);
            if (ObjectUtil.isNull((Object)rechargePackage)) {
                throw new CrmebException("\u60a8\u9009\u62e9\u7684\u5145\u503c\u65b9\u5f0f\u5df2\u4e0b\u67b6");
            }
            rechargePrice = new BigDecimal(rechargePackage.getPrice());
            gainPrice = new BigDecimal(rechargePackage.getGiveMoney());
        }
        if (rechargePrice.compareTo(rechargeMinAmount) < 0) {
            throw new CrmebException("\u5145\u503c\u91d1\u989d\u5c0f\u4e8e\u6700\u4f4e\u5145\u503c\u91d1\u989d");
        }
        String rechargeNo = CrmebUtil.getOrderNo((String)"CZ");
        OrderPayResultResponse response = new OrderPayResultResponse();
        RechargeOrder rechargeOrder = new RechargeOrder();
        if (request.getPayType().equals("weixin")) {
            MyRecord record = this.wechatPayment(rechargePrice, request.getPayChannel(), user.getId());
            WxPayJsResultVo vo = (WxPayJsResultVo)record.get("vo");
            String outTradeNo = record.getStr("outTradeNo");
            response.setJsConfig(vo);
            rechargeOrder.setOutTradeNo(outTradeNo);
        }
        if (request.getPayType().equals("alipay")) {
            String result = this.aliPayService.pay(rechargeNo, rechargePrice, "recharge", request.getPayChannel());
            response.setAlipayRequest(result);
            rechargeOrder.setOutTradeNo(rechargeNo);
        }
        rechargeOrder.setUid(user.getId());
        rechargeOrder.setOrderNo(rechargeNo);
        rechargeOrder.setPrice(rechargePrice);
        rechargeOrder.setGivePrice(gainPrice);
        rechargeOrder.setPayType(request.getPayType());
        rechargeOrder.setPayChannel(request.getPayChannel());
        boolean save = this.save(rechargeOrder);
        if (!save) {
            throw new CrmebException("\u751f\u6210\u5145\u503c\u8ba2\u5355\u5931\u8d25!");
        }
        return response;
    }

    private MyRecord wechatPayment(BigDecimal rechargePrice, String payChannel, Integer uid) {
        Map<String, String> unifiedorder = this.wechatUnifiedorder(rechargePrice, payChannel, uid);
        WxPayJsResultVo vo = new WxPayJsResultVo();
        vo.setAppId(unifiedorder.get("appId"));
        vo.setNonceStr(unifiedorder.get("nonceStr"));
        vo.setPackages(unifiedorder.get("package"));
        vo.setSignType(unifiedorder.get("signType"));
        vo.setTimeStamp(unifiedorder.get("timeStamp"));
        vo.setPaySign(unifiedorder.get("paySign"));
        if (payChannel.equals("h5")) {
            vo.setMwebUrl(unifiedorder.get("mweb_url"));
        }
        if (payChannel.equals("wechatIos") || payChannel.equals("wechatAndroid")) {
            vo.setPartnerid(unifiedorder.get("partnerid"));
        }
        MyRecord record = new MyRecord();
        record.set("vo", (Object)vo);
        record.set("outTradeNo", (Object)unifiedorder.get("outTradeNo"));
        return record;
    }

    private Map<String, String> wechatUnifiedorder(BigDecimal rechargePrice, String payChannel, Integer uid) {
        UserToken userToken = new UserToken();
        userToken.setToken("");
        if (payChannel.equals("public")) {
            userToken = this.userTokenService.getTokenByUserId(uid, UserConstants.USER_TOKEN_TYPE_WECHAT);
        }
        if (payChannel.equals("mini")) {
            userToken = this.userTokenService.getTokenByUserId(uid, UserConstants.USER_TOKEN_TYPE_ROUTINE);
        }
        String appId = "";
        String mchId = "";
        String signKey = "";
        switch (payChannel) {
            case "public": 
            case "h5": {
                appId = this.systemConfigService.getValueByKeyException("wechat_appid");
                mchId = this.systemConfigService.getValueByKeyException("pay_weixin_mchid");
                signKey = this.systemConfigService.getValueByKeyException("pay_weixin_key");
                break;
            }
            case "mini": {
                appId = this.systemConfigService.getValueByKeyException("routine_appid");
                mchId = this.systemConfigService.getValueByKeyException("pay_routine_mchid");
                signKey = this.systemConfigService.getValueByKeyException("pay_routine_key");
                break;
            }
            case "wechatIos": 
            case "wechatAndroid": {
                appId = this.systemConfigService.getValueByKeyException("wechat_app_appid");
                mchId = this.systemConfigService.getValueByKeyException("pay_weixin_app_mchid");
                signKey = this.systemConfigService.getValueByKeyException("pay_weixin_app_key");
            }
        }
        CreateOrderRequestVo unifiedorderVo = this.getUnifiedorderVo(rechargePrice, uid, userToken.getToken(), appId, mchId, signKey, payChannel);
        CreateOrderResponseVo responseVo = this.wechatService.payUnifiedorder(unifiedorderVo);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", unifiedorderVo.getAppid());
        map.put("nonceStr", unifiedorderVo.getNonce_str());
        map.put("package", "prepay_id=".concat(responseVo.getPrepayId()));
        map.put("signType", unifiedorderVo.getSign_type());
        Long currentTimestamp = WxPayUtil.getCurrentTimestamp();
        map.put("timeStamp", Long.toString(currentTimestamp));
        String paySign = WxPayUtil.getSign(map, (String)signKey);
        map.put("paySign", paySign);
        map.put("prepayId", responseVo.getPrepayId());
        map.put("prepayTime", CrmebDateUtil.nowDateTimeStr());
        map.put("outTradeNo", unifiedorderVo.getOut_trade_no());
        if (payChannel.equals("h5")) {
            map.put("mweb_url", responseVo.getMWebUrl());
        }
        if (payChannel.equals("wechatIos") || payChannel.equals("wechatAndroid")) {
            map.put("partnerid", mchId);
            map.put("package", responseVo.getPrepayId());
            HashMap<String, Object> appMap = new HashMap<String, Object>();
            appMap.put("appid", unifiedorderVo.getAppid());
            appMap.put("partnerid", mchId);
            appMap.put("prepayid", responseVo.getPrepayId());
            appMap.put("package", "Sign=WXPay");
            appMap.put("noncestr", unifiedorderVo.getNonce_str());
            appMap.put("timestamp", currentTimestamp);
            logger.info("================================================app\u652f\u4ed8\u7b7e\u540d\uff0cmap = " + appMap);
            String sign = WxPayUtil.getSignObject(appMap, (String)signKey);
            logger.info("================================================app\u652f\u4ed8\u7b7e\u540d\uff0csign = " + sign);
            map.put("paySign", sign);
        }
        return map;
    }

    private CreateOrderRequestVo getUnifiedorderVo(BigDecimal rechargePrice, Integer uid, String openid, String appId, String mchId, String signKey, String payChannel) {
        String domain = this.systemConfigService.getValueByKeyException("site_url");
        String apiDomain = this.systemConfigService.getValueByKeyException("api_url");
        AttachVo attachVo = new AttachVo("recharge", uid);
        CreateOrderRequestVo vo = new CreateOrderRequestVo();
        vo.setAppid(appId);
        vo.setMch_id(mchId);
        vo.setNonce_str(WxPayUtil.getNonceStr());
        vo.setSign_type("MD5");
        String siteName = this.systemConfigService.getValueByKeyException("site_name");
        vo.setBody(siteName);
        vo.setAttach(JSONObject.toJSONString((Object)attachVo));
        vo.setOut_trade_no(CrmebUtil.getOrderNo((String)"WX"));
        vo.setTotal_fee(rechargePrice.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue());
        vo.setSpbill_create_ip(RequestUtil.getClientIp());
        vo.setNotify_url(apiDomain + "/api/publicly/payment/callback/wechat");
        switch (payChannel) {
            case "h5": {
                vo.setTrade_type("MWEB");
                vo.setOpenid(null);
                break;
            }
            case "wechatIos": 
            case "wechatAndroid": {
                vo.setTrade_type("APP");
                vo.setOpenid(null);
                break;
            }
            default: {
                vo.setTrade_type("JSAPI");
                vo.setOpenid(openid);
            }
        }
        CreateOrderH5SceneInfoVo createOrderH5SceneInfoVo = new CreateOrderH5SceneInfoVo(new CreateOrderH5SceneInfoDetailVo(domain, this.systemConfigService.getValueByKeyException("site_name")));
        vo.setScene_info(JSONObject.toJSONString((Object)createOrderH5SceneInfoVo));
        String sign = WxPayUtil.getSign((CreateOrderRequestVo)vo, (String)signKey);
        vo.setSign(sign);
        return vo;
    }

    @Override
    public RechargeOrder getByOutTradeNo(String outTradeNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RechargeOrder::getOutTradeNo, (Object)outTradeNo);
        lqw.last(" limit 1");
        return (RechargeOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean paySuccessAfter(RechargeOrder rechargeOrder) {
        User user = (User)this.userService.getById(rechargeOrder.getUid());
        BigDecimal addPrice = rechargeOrder.getPrice().add(rechargeOrder.getGivePrice());
        BigDecimal balance = user.getNowMoney().add(addPrice);
        UserBalanceRecord record = new UserBalanceRecord();
        record.setUid(rechargeOrder.getUid());
        record.setLinkId(rechargeOrder.getOrderNo());
        record.setLinkType("recharge");
        record.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
        record.setAmount(addPrice);
        record.setBalance(balance);
        record.setRemark(StrUtil.format((CharSequence)"\u5145\u503c\u6210\u529f\uff0c\u4f59\u989d\u589e\u52a0{}\u5143", (Object[])new Object[]{addPrice}));
        Bill bill = new Bill();
        bill.setOrderNo(rechargeOrder.getOrderNo());
        bill.setUid(rechargeOrder.getUid());
        bill.setPm(BillConstants.BILL_PM_ADD);
        bill.setAmount(rechargeOrder.getPrice());
        bill.setType("recharge_user");
        bill.setMark(StrUtil.format((CharSequence)"\u5145\u503c\u8ba2\u5355\uff0c\u7528\u6237\u5145\u503c\u91d1\u989d{}\u5143", (Object[])new Object[]{rechargeOrder.getPrice()}));
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            boolean updatePaid = this.updatePaid(rechargeOrder.getId(), rechargeOrder.getOrderNo());
            if (!updatePaid) {
                logger.warn("\u5145\u503c\u8ba2\u5355\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25\uff0corderNo = {}", (Object)rechargeOrder.getOrderNo());
                e.setRollbackOnly();
            }
            this.userService.updateNowMoney(user.getId(), addPrice, "add");
            this.userBalanceRecordService.save(record);
            this.billService.save(bill);
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.asyncService.sendRechargeSuccessNotification(rechargeOrder, user);
        }
        return execute;
    }

    private boolean updatePaid(Integer id, String orderNo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(RechargeOrder::getPaid, (Object)true);
        wrapper.set(RechargeOrder::getPayTime, (Object)CrmebDateUtil.nowDateTime());
        wrapper.eq(RechargeOrder::getId, (Object)id);
        wrapper.eq(RechargeOrder::getOrderNo, (Object)orderNo);
        wrapper.eq(RechargeOrder::getPaid, (Object)false);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<RechargeOrder> findByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RechargeOrder::getPaid, (Object)true);
        lqw.apply("date_format(pay_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<RechargeOrder> findByMonth(String month) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RechargeOrder::getPaid, (Object)true);
        lqw.apply("date_format(pay_time, '%Y-%m') = {0}", new Object[]{month});
        return this.dao.selectList((Wrapper)lqw);
    }
}

