/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.bcx.BcxProductQuota;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxProductQuotaRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxProductQuotaResponse;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.BcxProductQuotaDao;
import com.zbkj.service.service.BcxProductQuotaService;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BcxProductQuotaServiceImpl
extends ServiceImpl<BcxProductQuotaDao, BcxProductQuota>
implements BcxProductQuotaService {
    @Resource
    private BcxProductQuotaDao dao;

    @Override
    public BcxProductQuotaResponse queryById(Integer id) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("merId", systemAdmin.getMerId());
        param.put("id", id);
        List<BcxProductQuotaResponse> quotas = this.dao.quoryQuotaList(param);
        if (CollUtil.isEmpty(quotas)) {
            throw new CrmebException("\u6ca1\u6709\u627e\u5230\u5c5e\u4e8e\u8be5\u5546\u6237\u7684\u5546\u54c1\u9650\u989d");
        }
        return quotas.get(0);
    }

    @Override
    public BcxProductQuota queryByProductId(Integer productId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxProductQuota::getProductId, (Object)productId);
        lqw.eq(BcxProductQuota::getEnabled, (Object)Boolean.TRUE);
        lqw.last(" limit 1");
        return (BcxProductQuota)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public PageInfo<BcxProductQuotaResponse> getPagedList(BcxProductQuotaRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("merId", systemAdmin.getMerId());
        param.put("name", request.getName());
        param.put("enabled", request.getEnabled());
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<BcxProductQuotaResponse> quotas = this.dao.quoryQuotaList(param);
        if (CollUtil.isEmpty(quotas)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new BcxProductQuotaResponse[0]));
        }
        return CommonPage.copyPageInfo((Page)page, quotas);
    }

    @Override
    public Boolean create(BcxProductQuotaRequest bcxProductQuota) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("merId", systemAdmin.getMerId());
        param.put("productId", bcxProductQuota.getProductId());
        List<BcxProductQuotaResponse> quotas = this.dao.quoryQuotaList(param);
        if (CollUtil.isNotEmpty(quotas)) {
            throw new CrmebException("\u5df2\u7ecf\u6709\u8be5\u5546\u54c1\u7684\u9650\u8d2d\u8bb0\u5f55");
        }
        BcxProductQuota quota = new BcxProductQuota();
        BeanUtils.copyProperties((Object)bcxProductQuota, (Object)quota);
        quota.setId(null);
        if (this.dao.insert(quota) > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean update(BcxProductQuotaRequest bcxProductQuota) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("merId", systemAdmin.getMerId());
        param.put("id", bcxProductQuota.getId());
        param.put("productId", bcxProductQuota.getProductId());
        List<BcxProductQuotaResponse> quotas = this.dao.quoryQuotaList(param);
        if (CollUtil.isEmpty(quotas)) {
            throw new CrmebException("\u627e\u4e0d\u5230\u8be5\u5546\u54c1\u7684\u9650\u8d2d\u8bb0\u5f55");
        }
        BcxProductQuota quota = new BcxProductQuota();
        BeanUtils.copyProperties((Object)bcxProductQuota, (Object)quota);
        if (this.dao.updateById(quota) > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean delete(Integer id) {
        BcxProductQuota quota = (BcxProductQuota)this.dao.selectById(id);
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("merId", systemAdmin.getMerId());
        param.put("id", quota.getId());
        param.put("productId", quota.getProductId());
        List<BcxProductQuotaResponse> quotas = this.dao.quoryQuotaList(param);
        if (CollUtil.isEmpty(quotas)) {
            throw new CrmebException("\u627e\u4e0d\u5230\u8be5\u5546\u54c1\u7684\u9650\u8d2d\u8bb0\u5f55");
        }
        if (this.dao.deleteById(id) > 0) {
            return true;
        }
        return false;
    }
}

