/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.payment.impls;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Maps;
import com.zbkj.bcx.cores.components.JsonProvider;
import com.zbkj.bcx.cores.constants.PaymentConstant;
import com.zbkj.bcx.cores.exceptions.BadCoreException;
import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.dto.HuifuWalletTransferDto;
import com.zbkj.common.exception.CrmebWalletException;
import com.zbkj.common.model.huifu.HuifuWalletTrade;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.payment.entities.PaymentTransactionEntity;
import com.zbkj.payment.mappers.PaymentTransactionMapper;
import com.zbkj.payment.mappers.dtos.PaymentStatusUpdateDTO;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletTradeDao;
import com.zbkj.service.payments.PaymentProvider;
import com.zbkj.service.payments.commands.CreateTransferCommand;
import com.zbkj.service.payments.commands.DonePaymentCommand;
import com.zbkj.service.payments.results.PaymentCommandResult;
import com.zbkj.service.payments.snapshots.PaymentTradeSnapshot;
import com.zbkj.service.payments.snapshots.PaymentTransferSnapshot;
import com.zbkj.service.service.CommonWalletService;
import com.zbkj.service.service.SystemConfigService;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

public abstract class PaymentProviderAbstract
implements PaymentProvider {
    protected static final DecimalFormat decimalFormat = new DecimalFormat("#0.00");
    private final RedisUtil redisUtil;
    private final RedissonClient redissonClient;
    private final SystemConfigService systemConfigService;
    private final HuifuWalletAccountDao huifuWalletAccountDao;
    private final HuifuWalletTradeDao huifuWalletTradeDao;
    private final TransactionTemplate transactionTemplate;
    private final CommonWalletService commonWalletService;
    private final JsonProvider jsonProvider;
    private final PaymentTransactionMapper transactionMapper;

    protected PaymentProviderAbstract(RedisUtil redisUtil, RedissonClient redissonClient, SystemConfigService systemConfigService, HuifuWalletAccountDao huifuWalletAccountDao, HuifuWalletTradeDao huifuWalletTradeDao, TransactionTemplate transactionTemplate, CommonWalletService commonWalletService, JsonProvider jsonProvider, PaymentTransactionMapper transactionMapper) {
        this.redisUtil = redisUtil;
        this.redissonClient = redissonClient;
        this.systemConfigService = systemConfigService;
        this.huifuWalletAccountDao = huifuWalletAccountDao;
        this.huifuWalletTradeDao = huifuWalletTradeDao;
        this.transactionTemplate = transactionTemplate;
        this.commonWalletService = commonWalletService;
        this.jsonProvider = jsonProvider;
        this.transactionMapper = transactionMapper;
    }

    public PaymentCommandResult offlinePayPlatTransfer(CreateTransferCommand command) {
        command.validate(this.redisUtil);
        PaymentTransferSnapshot snapshot = this.doValidatePaymentTransferSnapshot(command, false);
        if (Double.parseDouble(snapshot.getPlatAmount()) > 0.0) {
            HuifuWalletTransferDto dtoP = new HuifuWalletTransferDto();
            BeanUtils.copyProperties((Object)command, (Object)dtoP);
            dtoP.setAmount(String.valueOf(snapshot.getPlatAmount()));
            dtoP.setOutId(snapshot.getInAccountUniId());
            dtoP.setInId(snapshot.getPlatAccountUniId());
            dtoP.setComment(snapshot.getComment());
            dtoP.setBusinessPartnerSeq(dtoP.getBusinessPartnerSeq() + "-P" + command.getSellFeePriority());
            dtoP.setTradeType(snapshot.getTradeType());
            dtoP.setPayChannel(command.getPayChannel());
            HuifuWalletAccountDto outAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(command.getOutId(), this.getChannelName());
            Collection<PaymentTradeSnapshot> paymentTradeSnapshots = this.calculatePaymentTrades(false, snapshot, outAccount);
            PaymentCommandResult result = this.transferToPlat(dtoP, paymentTradeSnapshots, false);
            return result;
        }
        return null;
    }

    public PaymentCommandResult transfer(CreateTransferCommand command) {
        command.validate(this.redisUtil);
        HuifuWalletAccountDto outAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(command.getOutId(), this.getChannelName());
        if (outAccount == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u672a\u5f00\u901a\u94b1\u5305\u529f\u80fd");
        }
        PaymentTransferSnapshot snapshot = this.doValidatePaymentTransferSnapshot(command, true);
        if (!outAccount.getWalletAccountNo().equals(snapshot.getInWalletAccountNo())) {
            String reqSeqId;
            Collection<PaymentTradeSnapshot> paymentTradeSnapshots = this.calculatePaymentTrades(true, snapshot, outAccount);
            if (!CollectionUtils.isEmpty(paymentTradeSnapshots)) {
                Collection transactions = paymentTradeSnapshots.stream().map(ii -> {
                    PaymentTransactionEntity entity = PaymentTransactionEntity.create(ii.getBusinessPartnerSeq(), command.getBusinessPartnerSeq(), this.jsonProvider.toJson(ii));
                    if (ii.isPlatformFree()) {
                        entity.setStatus(PaymentTransactionEntity.TransactionStatus.PENDING);
                    }
                    return entity;
                }).collect(Collectors.toList());
                this.transactionTemplate.execute(e -> {
                    for (PaymentTransactionEntity entity : transactions) {
                        this.transactionMapper.insertOrUpdate(entity);
                    }
                    return Boolean.TRUE;
                });
            }
            if (StringUtils.isEmpty((CharSequence)(reqSeqId = (String)paymentTradeSnapshots.stream().filter(ii -> !ii.isPlatformFree()).map(ii -> ii.getBusinessPartnerSeq()).findFirst().orElse(null)))) {
                throw new BadCoreException("\u975e\u9884\u671f\u6570\u636e: \u652f\u4ed8\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put("outHuifuId", outAccount.getWalletAccountNo());
            p.put("reqSeqId", reqSeqId);
            p.put("scene", "PROTOCOL_WITHHOLD");
            p.put("ordAmt", command.getAmount());
            p.put("inWalletAccountNo", snapshot.getInWalletAccountNo());
            p.put("comment", command.getComment());
            p.put("goodDesc", command.getGoodsName() + "\u00d7" + command.getGoodsNumber() + command.getGoodsUnit());
            Map<String, Object> response = this.doYePayTransfer(p);
            if ("00000000".equals(PaymentProviderAbstract.RET(response, 1))) {
                // empty if block
            }
            return PaymentCommandResult.create(response, paymentTradeSnapshots, (boolean)false);
        }
        HashMap response = Maps.newHashMap();
        response.put("resp_code", "00000000");
        response.put("resp_desc", "\u4ed8\u65b9\u53c2\u4e0e\u8005Id\u76f8\u540c\u65f6\u8df3\u8fc7\u652f\u4ed8\u8bf7\u6c42");
        response.put("reqSeqId", PaymentConstant.getPaymentTranNoForMerchant((String)command.getBusinessPartnerSeq()));
        response.put("hfSeqId", command.getBusinessPartnerSeq());
        return null;
    }

    public void done(DonePaymentCommand command) {
        String rqSeqId = command.getReqSeqId();
    }

    public void done(DonePaymentCommand command, Collection<PaymentTradeSnapshot> paymentTradeSnapshots) {
        PaymentTradeSnapshot snapshot = paymentTradeSnapshots.stream().filter(ii -> ii.isPlatformFree() == command.isForPlatformFree()).findFirst().orElse(null);
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            HuifuWalletTrade huifuWalletTrade = new HuifuWalletTrade();
            huifuWalletTrade.setBusinessCode(snapshot.getBusinessCode());
            huifuWalletTrade.setBusinessPartnerSeq(snapshot.getBusinessPartnerSeq());
            huifuWalletTrade.setReqSeqId(command.getReqSeqId());
            huifuWalletTrade.setHfSeqId(command.getHfSeqId());
            huifuWalletTrade.setCreateTime(snapshot.getCreateTime());
            huifuWalletTrade.setUpdateTime(new Date());
            huifuWalletTrade.setGoodDesc(snapshot.getGoodDesc());
            huifuWalletTrade.setExpendAccountNo(snapshot.getExpendAccountNo());
            huifuWalletTrade.setIncomeAccountNo(snapshot.getIncomeAccountNo());
            huifuWalletTrade.setRemark(snapshot.getRemark());
            huifuWalletTrade.setUniId(snapshot.getUniId());
            huifuWalletTrade.setAmount(snapshot.getAmount());
            huifuWalletTrade.setTradeType(snapshot.getTradeType());
            huifuWalletTrade.setTradeStatus("P");
            huifuWalletTrade.setPayChannel(this.getChannelName());
            this.huifuWalletTradeDao.insertHuifuWalletTrade(huifuWalletTrade);
            int affectedCount = this.transactionMapper.updateStatus(PaymentStatusUpdateDTO.create(command.getReqSeqId(), command.getHfSeqId(), PaymentTransactionEntity.TransactionStatus.SUCCESS, "\u652f\u4ed8\u6210\u529f"));
            if (affectedCount <= 0) {
                throw new BadCoreException(String.format("\u975e\u9884\u671f\u5f02\u5e38: \u4ea4\u6613(%s)\u72b6\u6001\u66f4\u6539\u65e0\u53d8\u5316", command.getReqSeqId()));
            }
            if (!command.isForPlatformFree() && "04".equals(snapshot.getTradeType())) {
                this.syncUpdateSumFrozenAmount(snapshot.getInAccountUniId(), "04".equals(snapshot.getTradeType()) ? new BigDecimal(snapshot.getLockAmount()) : ("05".equals(snapshot.getTradeType()) ? new BigDecimal("-" + snapshot.getLockAmount()) : BigDecimal.ZERO));
            }
            return Boolean.TRUE;
        });
        if (!command.isForPlatformFree()) {
            if (StringUtils.isEmpty((CharSequence)snapshot.getPlatAmount())) {
                throw new BadCoreException("\u975e\u9884\u671f\u6570\u636e, \u5e73\u53f0\u8d39\u4e0d\u4e3a\u7a7a\u5b57\u7b26");
            }
            if (Double.parseDouble(snapshot.getPlatAmount()) > 0.0) {
                PaymentTradeSnapshot platformSnapshot = paymentTradeSnapshots.stream().filter(ii -> ii.isPlatformFree()).findFirst().orElse(null);
                if (platformSnapshot == null) {
                    throw new BadCoreException("\u975e\u9884\u671f\u5f02\u5e38: \u5e73\u53f0\u8d39\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
                }
                this.doForPlatformTransfer(platformSnapshot);
            }
        }
    }

    public void doForPlatformTransfer(PaymentTradeSnapshot platformSnapshot) {
        if (platformSnapshot == null) {
            throw new BadCoreException("\u975e\u9884\u671f\u5f02\u5e38: \u5e73\u53f0\u8d39\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletTransferDto dtoP = platformSnapshot.getPlatformTransfer();
        if (dtoP == null) {
            throw new BadCoreException("\u6570\u636e\u5f02\u5e38: \u5feb\u7167\u4fe1\u606f\u7684PlatformTransfer\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.transferToPlat(dtoP, Stream.of(platformSnapshot).collect(Collectors.toList()), true);
    }

    protected abstract Logger getLogger();

    protected PaymentTransferSnapshot doValidatePaymentTransferSnapshot(CreateTransferCommand command, boolean calculateLockAmount) {
        HuifuWalletAccountDto platAccount;
        HuifuWalletAccountDto inAccount;
        PaymentTransferSnapshot snapshot = PaymentTransferSnapshot.create((CreateTransferCommand)command);
        String tradeType = StringUtils.isEmpty((CharSequence)command.getTradeType()) ? "04" : command.getTradeType();
        String configPlatNo = this.systemConfigService.getValueByKey("ws_plat_no");
        snapshot.setPlatAmount(command.getPlatAmount());
        if (command.getSellFeePriority() == 0) {
            String lockAmount = command.getPlatAmount();
            snapshot.setPlatAmount(new BigDecimal(command.getAmount()).subtract(new BigDecimal(command.getPlatAmount())).toString());
            inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(configPlatNo);
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(command.getInId(), this.getChannelName());
        } else {
            String lockAmount = decimalFormat.format(new BigDecimal(command.getAmount()).subtract(new BigDecimal(command.getPlatAmount())));
            inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(command.getInId(), this.getChannelName());
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(configPlatNo);
        }
        if (inAccount == null) {
            throw new CrmebWalletException("\u5546\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        snapshot.setTradeType(tradeType);
        snapshot.setInAccountUniId(inAccount.getUniId());
        snapshot.setInWalletAccountNo(inAccount.getWalletAccountNo());
        snapshot.setPlatAccountUniId(platAccount.getUniId());
        snapshot.setPlatWalletAccountNo(platAccount.getWalletAccountNo());
        String comment = command.getSellFeePriority() == 0 ? "\u8ba2\u5355\u3010" + command.getBusinessPartnerSeq() + "\u3011\u652f\u4ed8\u5546\u54c1\u8d39\uff1a" + command.getPlatAmount() + "\u5143" : "\u8ba2\u5355\u3010" + command.getBusinessPartnerSeq() + "\u3011\u652f\u4ed8\u5e73\u53f0\u670d\u52a1\u8d39\uff1a" + command.getPlatAmount() + "\u5143";
        snapshot.setComment(comment);
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PaymentCommandResult transferToPlat(HuifuWalletTransferDto dto, Collection<PaymentTradeSnapshot> tradeSnapshots, boolean ignoreExceptionWithAsyncRetry) {
        this.getLogger().info(">>>>>>>>> \u4e8c\u7ea7\u5206\u8d26\u4e1a\u52a1transferToPlat\uff1a{},\u5f00\u59cb;transferToPlat.param:{}", (Object)dto.getBusinessPartnerSeq(), (Object)JSONObject.toJSONString((Object)dto));
        StopWatch stopWatch = new StopWatch();
        try {
            Map<String, Object> response;
            stopWatch.start();
            if (StringUtil.isEmpty((String)dto.getGoodsName())) {
                throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
                throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
                throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HuifuWalletAccountDto outAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getOutId(), this.getChannelName());
            if (outAccount == null) {
                throw new CrmebWalletException("\u4e8c\u7ea7\u5206\u8d26\u5f02\u5e38\uff1a\u4f01\u4e1a\u672a\u5f00\u901a\u94b1\u5305\u529f\u80fd");
            }
            HuifuWalletAccountDto inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), this.getChannelName());
            if (inAccount == null) {
                throw new CrmebWalletException("\u4e8c\u7ea7\u5206\u8d26\u5f02\u5e38\uff1a\u5546\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            String lockAmount = "0";
            String availableAmount = "0";
            if ("04".equals(dto.getTradeType())) {
                lockAmount = dto.getAmount();
            } else {
                availableAmount = dto.getAmount();
            }
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put("scene", "PROTOCOL_WITHHOLD");
            p.put("freezeAmount", lockAmount);
            p.put("availableAmount", availableAmount);
            p.put("outHuifuId", outAccount.getWalletAccountNo());
            p.put("reqSeqId", dto.getBusinessPartnerSeq());
            p.put("ordAmt", dto.getAmount());
            p.put("inAmount", decimalFormat.format(new BigDecimal(dto.getAmount())));
            p.put("inWalletAccountNo", inAccount.getWalletAccountNo());
            p.put("comment", dto.getComment());
            p.put("goodDesc", dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
            try {
                response = this.doYePayTransfer(p);
            }
            catch (Exception e) {
                this.getLogger().error("===>transferToPlat.\u4e8c\u7ea7\u5206\u8d26\u5f02\u5e38\uff1a" + e.getMessage());
                throw new CrmebWalletException("\u652f\u4ed8\u5f02\u5e38" + e.getMessage());
            }
            if (!"00000000".equals(PaymentProviderAbstract.RET(response, 1))) {
                throw new CrmebWalletException(String.format("\u652f\u4ed8\u5f02\u5e38:%s", PaymentProviderAbstract.RET(response, 2)));
            }
            this.done(DonePaymentCommand.create((String)response.get("reqSeqId").toString(), (String)response.get("hfSeqId").toString(), (boolean)true), tradeSnapshots);
            PaymentCommandResult paymentCommandResult = PaymentCommandResult.create(response, tradeSnapshots, (boolean)true);
            return paymentCommandResult;
        }
        catch (Exception ex) {
            if (!ignoreExceptionWithAsyncRetry) {
                throw ex;
            }
            PaymentCommandResult paymentCommandResult = null;
            return paymentCommandResult;
        }
        finally {
            stopWatch.stop();
            this.getLogger().info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a{}, \u652f\u4ed8\u786e\u8ba4\uff1asucc: \u603b\u8017\u65f6{}\u79d2", (Object)dto.getBusinessPartnerSeq(), (Object)stopWatch.getTotalTimeSeconds());
        }
    }

    public void syncUpdateSumFrozenAmount(String uniId, BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        this.getLogger().error(">>>>>>>>> \u4f01\u4e1a\u51bb\u7ed3\u91d1\u989d\u8ba1\u7b97modifyBalance.\u5f00\u59cb\uff1auniId={}; amount={};", (Object)uniId, (Object)amount);
        this.commonWalletService.modifyBalance(uniId, amount, this.getChannelName());
    }

    protected static String RET(Map<String, Object> response, int type) {
        if (type == 1) {
            return response.get("resp_code").toString();
        }
        return response.get("resp_desc").toString();
    }

    protected abstract Map<String, Object> doYePayTransfer(Map<String, Object> var1);

    protected Collection<PaymentTradeSnapshot> calculatePaymentTrades(boolean forTransfer, PaymentTransferSnapshot snapshot, HuifuWalletAccountDto outAccount) {
        Date date = new Date();
        ArrayList<PaymentTradeSnapshot> snapshots = new ArrayList<PaymentTradeSnapshot>();
        CreateTransferCommand command = snapshot.getCommand();
        if (forTransfer) {
            PaymentTradeSnapshot data = new PaymentTradeSnapshot();
            BeanUtils.copyProperties((Object)command, (Object)data);
            data.setBusinessCode(command.getBusinessCode());
            data.setBusinessPartnerSeq(PaymentConstant.getPaymentTranNoForMerchant((String)command.getBusinessPartnerSeq()));
            data.setCreateTime(date);
            data.setUpdateTime(date);
            data.setGoodDesc(command.getGoodsName() + "\u00d7" + command.getGoodsNumber() + command.getGoodsUnit());
            data.setExpendAccountNo(outAccount.getWalletAccountNo());
            data.setIncomeAccountNo(snapshot.getInWalletAccountNo());
            data.setRemark(command.getComment());
            data.setUniId(outAccount.getUniId());
            data.setAmount(new BigDecimal(command.getAmount()));
            data.setTradeType(command.getTradeType());
            data.setTradeStatus("I");
            data.setPayChannel(this.getChannelName());
            data.setPlatformFree(false);
            snapshots.add(data);
        }
        if (Double.parseDouble(snapshot.getPlatAmount()) > 0.0) {
            HuifuWalletTransferDto dto = new HuifuWalletTransferDto();
            BeanUtils.copyProperties((Object)command, (Object)dto);
            dto.setAmount(snapshot.getPlatAmount());
            dto.setOutId(snapshot.getInAccountUniId());
            dto.setInId(snapshot.getPlatAccountUniId());
            dto.setComment(snapshot.getComment());
            dto.setBusinessPartnerSeq(PaymentConstant.getPaymentTranNoForPlatform((String)command.getBusinessPartnerSeq()));
            dto.setTradeType(snapshot.getTradeType());
            PaymentTradeSnapshot platformData = new PaymentTradeSnapshot();
            platformData.setBusinessCode(dto.getBusinessCode());
            platformData.setBusinessPartnerSeq(dto.getBusinessPartnerSeq());
            platformData.setCreateTime(date);
            platformData.setUpdateTime(new Date());
            platformData.setGoodDesc(dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
            platformData.setExpendAccountNo(snapshot.getInWalletAccountNo());
            platformData.setIncomeAccountNo(snapshot.getPlatWalletAccountNo());
            platformData.setRemark(dto.getComment());
            platformData.setUniId(outAccount.getUniId());
            platformData.setAmount(new BigDecimal(dto.getAmount()));
            platformData.setTradeType(dto.getTradeType());
            platformData.setTradeStatus("I");
            platformData.setPayChannel(this.getChannelName());
            platformData.setPlatformFree(true);
            platformData.setPlatformTransfer(dto);
            snapshots.add(platformData);
        }
        return snapshots;
    }
}

