/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bill.SummaryFinancialStatements;
import com.zbkj.common.model.closing.MerchantClosingRecord;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.RechargeOrder;
import com.zbkj.common.model.order.RefundOrder;
import com.zbkj.common.model.user.UserClosing;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.SummaryFinancialStatementsDao;
import com.zbkj.service.service.MerchantClosingRecordService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.RechargeOrderService;
import com.zbkj.service.service.RefundOrderService;
import com.zbkj.service.service.SummaryFinancialStatementsService;
import com.zbkj.service.service.UserClosingService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SummaryFinancialStatementsServiceImpl
extends ServiceImpl<SummaryFinancialStatementsDao, SummaryFinancialStatements>
implements SummaryFinancialStatementsService {
    @Resource
    private SummaryFinancialStatementsDao dao;
    @Autowired
    private OrderService orderService;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private RechargeOrderService rechargeOrderService;
    @Autowired
    private MerchantClosingRecordService merchantClosingRecordService;
    @Autowired
    private UserClosingService userClosingService;

    @Override
    public PageInfo<SummaryFinancialStatements> getPageList(String dateLimit, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (StrUtil.isNotEmpty((CharSequence)dateLimit)) {
            DateLimitUtilVo dateLimitVo = CrmebDateUtil.getDateLimit((String)dateLimit);
            String startDate = DateUtil.parse((String)dateLimitVo.getStartTime()).toDateStr();
            String endDate = DateUtil.parse((String)dateLimitVo.getEndTime()).toDateStr();
            lqw.between(SummaryFinancialStatements::getDataDate, (Object)startDate, (Object)endDate);
        }
        lqw.orderByDesc(SummaryFinancialStatements::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)list)) {
            return CommonPage.copyPageInfo((Page)page, (List)list);
        }
        String today = DateUtil.date().toDateStr();
        for (SummaryFinancialStatements statements : list) {
            if (!statements.getDataDate().equals(today)) continue;
            this.writeDailyStatement(statements);
        }
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public SummaryFinancialStatements getByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SummaryFinancialStatements::getDataDate, (Object)date);
        lqw.last(" limit 1");
        return (SummaryFinancialStatements)this.dao.selectOne((Wrapper)lqw);
    }

    private void writeDailyStatement(SummaryFinancialStatements statements) {
        List<Order> orderList = this.orderService.findPayByDate(0, statements.getDataDate());
        List<RefundOrder> refundOrderList = this.refundOrderService.findByDate(0, statements.getDataDate());
        List<RechargeOrder> rechargeOrderList = this.rechargeOrderService.findByDate(statements.getDataDate());
        List<MerchantClosingRecord> merchantClosingRecordList = this.merchantClosingRecordService.findByDate(0, statements.getDataDate());
        List<UserClosing> userClosingList = this.userClosingService.findByDate(statements.getDataDate());
        statements.setRechargeAmount(rechargeOrderList.stream().map(RechargeOrder::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        statements.setRechargeNum(Integer.valueOf(rechargeOrderList.size()));
        statements.setWechatPayAmount(orderList.stream().filter(e -> e.getPayType().equals("weixin")).map(Order::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        statements.setWechatPayNum(Integer.valueOf((int)orderList.stream().filter(e -> e.getPayType().equals("weixin")).count()));
        statements.setAliPayAmount(orderList.stream().filter(e -> e.getPayType().equals("alipay")).map(Order::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        statements.setAliPayNum(Integer.valueOf((int)orderList.stream().filter(e -> e.getPayType().equals("alipay")).count()));
        statements.setIncomeAmount(statements.getRechargeAmount().add(statements.getWechatPayAmount()).add(statements.getAliPayAmount()));
        statements.setMerchantSplitSettlement(merchantClosingRecordList.stream().map(MerchantClosingRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        statements.setMerchantSplitSettlementNum(Integer.valueOf(merchantClosingRecordList.size()));
        statements.setBrokerageSettlement(userClosingList.stream().map(UserClosing::getClosingPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        statements.setBrokerageSettlementNum(Integer.valueOf(userClosingList.size()));
        statements.setOrderRefundAmount(refundOrderList.stream().map(RefundOrder::getRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        statements.setOrderRefundNum(Integer.valueOf(refundOrderList.size()));
        statements.setPayoutAmount(statements.getMerchantSplitSettlement().add(statements.getBrokerageSettlement()).add(statements.getOrderRefundAmount()));
        statements.setIncomeExpenditure(statements.getIncomeAmount().subtract(statements.getPayoutAmount()));
    }
}

