/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.zzx.zhongan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.LOTEPolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageMessageZhongAn {
    private static Logger logger = LoggerFactory.getLogger(PackageMessageZhongAn.class);
    private static final String FORMAT = "json";
    private static final String SIGNTYPE = "md5";
    private static final String CHARSET = "utf-8";

    public static JSONObject marshal(LOTEPolicyVo vo, OrderFormVo dto, String transType, Map<String, String> map) throws Exception {
        JSONObject mapP = new JSONObject();
        if ("1".equals(transType)) {
            mapP.put("productCode", (Object)PackageMessageZhongAn.matchProductCode(dto.getProduct_code()));
            mapP.put("channelOrderNo", (Object)dto.getTrade_serial_number());
            PackageMessageZhongAn.setOrderInfo_1(mapP, vo, dto);
        } else if ("2".equals(transType)) {
            mapP.put("productCode", (Object)PackageMessageZhongAn.matchProductCode(dto.getProduct_code()));
            mapP.put("channelOrderNo", (Object)dto.getTrade_serial_number());
            PackageMessageZhongAn.setOrderInfo_2(mapP, vo, dto, map);
            PackageMessageZhongAn.setTranInfo(mapP, map);
        } else if ("3".equals(transType)) {
            // empty if block
        }
        return mapP;
    }

    private static String matchProductCode(String pCode) {
        if ("ZZX-ZA-1".equals(pCode)) {
            return "ff633ad873686cf6b007a1e34f48aa1423d6b9eb19b9";
        }
        if ("ZZX-ZA-2".equals(pCode)) {
            return "ff633ad873686cf6b007a1e34f48aa1423d6b9eb18b9";
        }
        if ("ZZX-ZA-3".equals(pCode)) {
            return "ff633ad873686cf6b007a1e34f48aa1423d6b9ea11b9";
        }
        return "";
    }

    private static void setTranInfo(JSONObject map, Map<String, String> mapTran) {
        map.put("outTradeNo", (Object)mapTran.get("out_trade_no"));
        map.put("zaTradeNo", (Object)mapTran.get("trade_no"));
        map.put("premiumPayAmount", (Object)mapTran.get("amt"));
        map.put("premiumPayTime", (Object)PackageMessageZhongAn.setDates(mapTran.get("pay_time")));
        map.put("premiumPayType", (Object)PackageMessageZhongAn.getPayType(mapTran.get("pay_channel")));
    }

    private static String getPayType(String str) {
        if ("alipay".equals(str)) {
            return "1";
        }
        if ("wxpay".equals(str)) {
            return "4";
        }
        if ("unionpay".equals(str) || "unionpayB2B".equals(str)) {
            return "8";
        }
        return "";
    }

    private static void setOrderInfo_1(JSONObject map, LOTEPolicyVo vo, OrderFormVo dto) {
        PackageMessageZhongAn.setAppAndInsInfo(map, vo, dto);
        String email = "zhongxuefeng@bcxin.com.cn";
        for (RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()) {
            if (!"1".equals(roleSubjectVo.getKind())) continue;
            email = roleSubjectVo.getLink_email();
            break;
        }
        map.put("premiumAmount", (Object)dto.getGross_premium());
        boolean nr = "1".equals(vo.getMailPolicyVo().getNeed_receipt());
        boolean it = false;
        if (nr) {
            it = "0".equals(vo.getMailPolicyVo().getInvoice_type());
        }
        map.put("requireInvoice", (Object)(it ? "Y" : "N"));
        map.put("contactMail", (Object)email);
        JSONObject mapEx = new JSONObject();
        mapEx.put("address", (Object)RegionUtils.getRegionNameByALLCode((String)vo.getSpecialExhibitionVo().getEx_province(), (String)vo.getSpecialExhibitionVo().getEx_city(), (String)vo.getSpecialExhibitionVo().getEx_county()));
        mapEx.put("numberOfEmployees", (Object)vo.getSpecialExhibitionVo().getEx_emp_num());
        mapEx.put("space", (Object)vo.getSpecialExhibitionVo().getEx_acreage());
        SimpleDateFormat dateFormatAny = new SimpleDateFormat("yyyyMMddHHmmss");
        mapEx.put("policyEffectiveDate", (Object)String.valueOf(dateFormatAny.format(DateUtil.convertStringToDate((String)(vo.getSpecialExhibitionVo().getStar_time() + " 00:00:00")).getTime())));
        mapEx.put("policyExpiryDate", (Object)String.valueOf(dateFormatAny.format(DateUtil.convertStringToDate((String)(vo.getSpecialExhibitionVo().getEnd_time() + " 23:59:59")).getTime())));
        map.put("extraInfo", (Object)mapEx.toString());
    }

    private static void setOrderInfo_2(JSONObject map, LOTEPolicyVo vo, OrderFormVo dto, Map<String, String> maps) {
        PackageMessageZhongAn.setAppAndInsInfo(map, vo, dto);
        String email = "zhongxuefeng@bcxin.com.cn";
        for (RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()) {
            if (!"1".equals(roleSubjectVo.getKind())) continue;
            email = roleSubjectVo.getLink_email();
            break;
        }
        map.put("premiumAmount", (Object)dto.getGross_premium());
        boolean nr = "1".equals(vo.getMailPolicyVo().getNeed_receipt());
        boolean it = false;
        if (nr) {
            it = "0".equals(vo.getMailPolicyVo().getInvoice_type());
        }
        map.put("requireInvoice", (Object)(it ? "Y" : "N"));
        map.put("contactMail", (Object)email);
        JSONObject mapEx = new JSONObject();
        mapEx.put("address", (Object)RegionUtils.getRegionNameByALLCode((String)vo.getSpecialExhibitionVo().getEx_province(), (String)vo.getSpecialExhibitionVo().getEx_city(), (String)vo.getSpecialExhibitionVo().getEx_county()));
        mapEx.put("numberOfEmployees", (Object)vo.getSpecialExhibitionVo().getEx_emp_num());
        mapEx.put("space", (Object)vo.getSpecialExhibitionVo().getEx_acreage());
        mapEx.put("payTradeNo", (Object)maps.get("pay_trade_no"));
        SimpleDateFormat dateFormatAny = new SimpleDateFormat("yyyyMMddHHmmss");
        mapEx.put("policyEffectiveDate", (Object)String.valueOf(dateFormatAny.format(DateUtil.convertStringToDate((String)(vo.getSpecialExhibitionVo().getStar_time() + " 00:00:00")).getTime())));
        mapEx.put("policyExpiryDate", (Object)String.valueOf(dateFormatAny.format(DateUtil.convertStringToDate((String)(vo.getSpecialExhibitionVo().getEnd_time() + " 23:59:59")).getTime())));
        map.put("extraInfo", (Object)mapEx.toString());
    }

    private static String getIDType(String str) {
        if ("1".equals(str)) {
            return "Z";
        }
        if ("2".equals(str)) {
            return "TY";
        }
        if ("6".equals(str)) {
            return "T";
        }
        if ("7".equals(str)) {
            return "L";
        }
        return "";
    }

    private static void setAppAndInsInfo(JSONObject map, LOTEPolicyVo vo, OrderFormVo dto) {
        for (RoleSubjectVo roleSubjectVo : vo.getRoleSubjectList()) {
            if ("1".equals(roleSubjectVo.getKind())) {
                map.put("policyHolderUserName", (Object)roleSubjectVo.getName_cn());
                map.put("policyHolderCertiType", (Object)PackageMessageZhongAn.getIDType(roleSubjectVo.getId_type()));
                map.put("policyHolderCertiNo", (Object)roleSubjectVo.getOrganization_code());
                map.put("policyHolderPhone", (Object)roleSubjectVo.getLink_tel());
            }
            if (!"2".equals(roleSubjectVo.getKind())) continue;
            map.put("insuredUserName", (Object)roleSubjectVo.getName_cn());
            map.put("insuredCertiType", (Object)PackageMessageZhongAn.getIDType(roleSubjectVo.getId_type()));
            map.put("insuredCertiNo", (Object)roleSubjectVo.getOrganization_code());
            map.put("insuredPhone", (Object)roleSubjectVo.getLink_tel());
            map.put("policyHolderBirthDate", (Object)"");
            map.put("insuredBirthDay", (Object)"");
            map.put("policyHolderType", (Object)"2");
            SimpleDateFormat dateFormatAny = new SimpleDateFormat("yyyyMMddHHmmss");
            map.put("insureDate", (Object)String.valueOf(dateFormatAny.format(DateUtil.convertStringToDate((String)dto.getStart_time()).getTime())));
        }
    }

    public static String returnAnalysisJson(String json, String transType) {
        block7: {
            String result = "";
            try {
                Map map = (Map)JSON.parseObject((String)json, Map.class);
                if (map != null) {
                    if ("N".equals(map.get("issueResultType"))) {
                        return "300#\uff08APP-ZA-300.02\uff09" + map.get("issueErrorDetail");
                    }
                    if (transType.equals("1")) {
                        return "200#BCX-" + IdWorker.getId();
                    }
                    if (transType.equals("2")) {
                        return "200#" + map.get("policyNo") + "#" + map.get("contractURL");
                    }
                    if (transType.equals("3")) {
                        return "200#";
                    }
                    break block7;
                }
                return "300#\uff08APP-ZA-300.09\uff09\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "300#\uff08APP-ZA-300.10\uff09\u5f02\u5e38\u9519\u8bef";
            }
        }
        return "";
    }

    private static String setDates(String doTime) {
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)doTime)) {
            result = DateUtil.convertDateToString((Date)DateUtil.convertString2Date((String)doTime), (String)"yyyyMMddHHmmss");
        }
        return result;
    }

    private static String getDate(String doTime, int status) {
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)doTime)) {
            try {
                if (status == 0) {
                    result = DateUtil.convertDateToString((Date)DateUtil.parseDate((String)doTime), (String)"yyyy-MM-dd");
                } else if (status == 1) {
                    result = DateUtil.convertDateToString((Date)DateUtil.parseDate((String)doTime), (String)"yyyy-MM-dd");
                    if (StringUtils.isNotEmpty((CharSequence)result)) {
                        result = result + " 00:00:00";
                    }
                } else if (status == 2) {
                    Date beT = DateUtil.parseDate((String)doTime);
                    Calendar cDate = Calendar.getInstance();
                    cDate.setTime(beT);
                    cDate.set(5, cDate.get(5) - 1);
                    result = DateUtil.convertDateToString((Date)beT, (String)"yyyy-MM-dd");
                    if (StringUtils.isNotEmpty((CharSequence)result)) {
                        result = result + " 23:59:59";
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static String getCityCodeByPro(String pro, String city) {
        if ("110000".equals(pro)) {
            return pro;
        }
        if ("120000".equals(pro)) {
            return pro;
        }
        if ("500000".equals(pro)) {
            return pro;
        }
        if ("310000".equals(pro)) {
            return pro;
        }
        if ("710000".equals(pro)) {
            return pro;
        }
        if ("810000".equals(pro)) {
            return pro;
        }
        if ("820000".equals(pro)) {
            return pro;
        }
        return city;
    }

    public static void main(String[] args) {
    }
}

